% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameGenerics.R
\name{coords.CMBDataFrame}
\alias{coords.CMBDataFrame}
\title{Coordinate system from a \code{\link{CMBDataFrame}}}
\usage{
\method{coords}{CMBDataFrame}(x, new.coords, ...)
}
\arguments{
\item{x}{A CMBDataFrame, \code{cmbdf}.}

\item{new.coords}{Specifies the new coordinate
system ("spherical" or "cartesian")
if a change of coordinate system is desired.}

\item{...}{Unused arguments.}
}
\value{
If new.coords is unspecified, then the name of the coordinate system
of \code{cmbdf} is returned. Otherwise a new CMBDataFrame is returned
equivalent to \code{cmbdf} but having the desired change of coordinates
}
\description{
If \code{new.coords} is unspecified then
this function returns the coordinate system used in the CMBDataFrame
\code{cmbdf}.
The coordinate system is either "cartesian" or "spherical".
If a new coordinate system is specified, using e.g.
\code{new.coords = "spherical"}, then this function instead
returns a new CMBDataFrame whose coordinates are of the specified
type. The original CMBDataFrame, \code{cmbdf}, is unaffected.
If you would like to change \code{cmbdf} without creating a new
variable, then use \code{\link{coords<-.CMBDataFrame}} (see
examples below).
}
\examples{

## Create df with no coords, then create df2 with cartesian coords
df <- CMBDataFrame(nside = 16)
df
coords(df)
df2 <- coords(df, new.coords = "cartesian")
coords(df2)


## Change the coords of df directly (to spherical)
coords(df) <- "spherical"
coords(df)

}
