% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_daily_decomp.R
\name{ts_daily_decomp}
\alias{ts_daily_decomp}
\title{Time Series Forecast and Decomposition for Daily Crime Data}
\usage{
ts_daily_decomp(data, start)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}

\item{start}{Start date for the time series being analyzed. The format is as
follows: c('year', 'month', 'day'). See example below for reference.}
}
\value{
Returns a list of four plots: the overall crime trend with forecast;
    the daily seasonality; the weekly seasonality; and the yearly seasonality
    components.
}
\description{
Plot the components of forecast generated using the \pkg{prophet}
    which includes the overall crime trend and the daily, weekly, and yearly
    seasonality components. Holt Winters exponential smoothing is also
    performed to the seasonality component for inproved trend resolution since
    the data is in a daily format.
}
\examples{
#Using provided dataset from Chicago Data Portal:
data(crimes)
test <- ts_month_decomp(data = crimes, start = c(2017, 1, 1))
plot(test)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{ts}
