<!--
%\VignetteEngine{knitr::knitr}
%\VignetteIndexEntry{Crossref filters}
%\VignetteEncoding{UTF-8}
-->



## Crossref Filter Names

These are associated with the Fundref API

Since these Crossref options use dashes in the names in the API, we provide a crosswalk to these so that you can use underscores wherever they use dashes. Also, filters that have dots in them are undscores instead, so `license.url` becomes `license_url`. Additionally, using colons is not very R like, so if Crossref requires `has-funder:true`, just do `has-funder=TRUE` in R. Pass these options in to the `cr_*()` functions in the filter parameter as a list, e.g., `filter=list(has_funder=TRUE, has_full_text=TRUE)`

Filters allow you to narrow queries. All filter results are lists.  The following filters are supported:

| filter     | possible values | description|
|:-----------|:----------------|:-----------|
| `has_funder` | `{logical}` | metadata which includes one or more funder entry |
| `funder` | `{funder_id}` | metadata which include the `{funder_id}` in FundRef data |
| `prefix` | `{owner_prefix}` | metadata belonging to a DOI owner prefix `{owner_prefix}` (e.g. `10.1016` ) |
| `member` | `{member_id}` | metadata belonging to a CrossRef member |
| `from_index_date` | `{date}` | metadata indexed since (inclusive) `{date}` |
| `until_index_date` | `{date}` | metadata indexed before (inclusive) `{date}` |
| `from_deposit_date` | `{date}` | metadata last (re)deposited since (inclusive) `{date}` |
| `until_deposit_date` | `{date}` | metadata last (re)deposited before (inclusive) `{date}` |
| `from_update_date` | `{date}` | Metadata updated since (inclusive) `{date}`. Currently the same as `from_deposit_date`. |
| `until_update_date` | `{date}` | Metadata updated before (inclusive) `{date}`. Currently the same as `until_deposit_date`. |
| `from_first_deposit_date` | `{date}` | metadata first deposited since (inclusive) `{date}` [^*] |
| `until_first_deposit_date` | `{date}` | metadata first deposited before (inclusive) `{date}` [^*] |
| `from_pub_date` | `{date}` | metadata where published date is since (inclusive) `{date}` |
| `until_pub_date` | `{date}` | metadata where published date is before (inclusive)  `{date}` |
| `has_license` | `{logical}` | metadata that includes any `<license_ref>` elements. |
| `license_url` | `{url}` | metadata where `<license_ref>` value equals `{url}` |
| `license_version` | `{string}` | metadata where the `<license_ref>`'s `applies_to` attribute  is `{string}`|
| `license_delay` | `{integer}` | metadata where difference between publication date and the `<license_ref>`'s `start_date` attribute is <= `{integer}` (in days)|
| `has_full_text` | `{logical}` | metadata that includes any full text `<resource>` elements. |
| `full_text_version` | `{string}`  | metadata where `<resource>` element's `content_version` attribute is `{string}`. |
| `full_text_type` | `{mime_type}`  | metadata where `<resource>` element's `content_type` attribute is `{mime_type}` (e.g. `application/pdf`). |
| `public_references` | | metadata where publishers allow references to be distributed publicly. [^*] |
| `has_references` | `{logical}` | metadata for works that have a list of references |
| `has_archive` | `{logical}` | metadata which include name of archive partner |
| `archive` | `{string}` | metadata which where value of archive partner is `{string}` |
| `has_orcid` | `{logical}` | metadata which includes one or more ORCIDs |
| `orcid` | `{orcid}` | metadata where `<orcid>` element's value = `{orcid}` |
| `issn` | `{issn}` | metadata where record has an ISSN = `{issn}`. Format is `xxxx-xxxx`. |
| `type` | `{type}` | metadata records whose type = `{type}`. Type must be an ID value from the list of types returned by the `/types` resource |
| `directory` | `{directory}` | metadata records whose article or serial are mentioned in the given `{directory}`. Currently the only supported value is `doaj`. |
| `doi` | `{doi}` | metadata describing the DOI `{doi}` |
| `updates` | `{doi}` | metadata for records that represent editorial updates to the DOI `{doi}` |
| `is_update` | `{logical}` | metadata for records that represent editorial updates |
| `has_update_policy` | `{logical}` | metadata for records that include a link to an editorial update policy |
| `container_title` | | metadata for records with a publication title exactly with an exact match |
| `publisher_name` | | metadata for records with an exact matching publisher name |
| `category_name` | |metadata for records with an exact matching category label |
| `type_name` | | metadata for records with an exactly matching type label |
| `award_number` |{`award_number`} |metadata for records with a matching award number. Optionally combine with `award_funder` |
| `award_funder` | {`funder doi or id`} | metadata for records with an award with matching funder. Optionally combine with `award_number` |
| `from_created_date` | {`date`} | metadata first deposited since (inclusive) `{date}` |
| `until_created_date` | {`date`} | metadata first deposited before (inclusive) `{date}` |
| `affiliation` | | metadata for records with at least one contributor with the given affiliation |
| `has_affiliation`| | metadata for records that have any affiliation information |
| `article_number` | | metadata for records with a given article number |
| `alternative_id` | | metadata for records with the given alternative ID, which may be a publisher_specific ID, or any other identifier a publisher may have provided |
| `assertion_group` | | metadata for records with an assertion in a particular group |
| `assertion` | | metadata for records with a particular named assertion |

[^*]: Not implemented yet.
