% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_standardsCompliance}
\alias{ddi_standardsCompliance}
\alias{ddi_complianceDescription}
\title{standardsCompliance and its child nodes}
\usage{
ddi_standardsCompliance(...)

ddi_complianceDescription(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
The standards compliance section lists all specific standards complied with
during the execution of this study.  More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{standardsCompliance} is contained in \code{qualityStatement}.

\emph{standardsCompliance specific child nodes}
\itemize{
\item \code{ddi_complianceDescription} describes how the study complied with each
standard.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_standard]{ddi_standard()}}
}
}

\examples{
# Note: ddi_standard() is a required child for ddi_standardsCompliance()
ddi_standardsCompliance(ddi_standard())

# Functions that need to be wrapped in ddi_standardsCompliance()

ddi_complianceDescription("This study complied to X standard by...")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/standardsCompliance.html}{standardsCompliance documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/complianceDescription.html}{complianceDescription documentation}
}
