% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeamService.R
\name{dfp_createTeams}
\alias{dfp_createTeams}
\title{TeamService}
\usage{
dfp_createTeams(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createTeamsResponse
}
\description{
Provides methods for creating, updating, and retrieving Team objects.
}
\details{
Teams are used to group users in order to define access to entities such as
companies, inventory and orders.

createTeams

Creates new Team objects. The following fields are required: 
\itemize{
  \item{Team name}
}
}
\examples{
\dontrun{
request_data <- list(teams=list(name="TestTeam1", 
                                description='API Test Team 1', 
                                hasAllCompanies='true', 
                                hasAllInventory='true',
                                teamAccessType='READ_WRITE'))
result <- dfp_createTeams(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/TeamService#createTeams}{Google Documentation for createTeams}
}
