% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProposalService.R
\name{dfp_performProposalAction}
\alias{dfp_performProposalAction}
\title{performProposalAction}
\usage{
dfp_performProposalAction(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a performProposalActionResponse
}
\description{
Performs actions on Proposal objects that match the given Statement query. The following fields are also required when submitting proposals for approval:
\itemize{
  \item{Proposal advertiser}
  \item{Proposal primarySalesperson}
  \item{Proposal primaryTraffickerId}
}
}
\examples{
\dontrun{
 res <- dfp_performProposalAction(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/ProposalService#performProposalAction}{Google Documentation for performProposalAction}
}
