% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items.r
\name{dpla_items}
\alias{dpla_items}
\title{Search items from the Digital Public Library of America (DPLA).}
\usage{
dpla_items(q = NULL, description = NULL, title = NULL, subject = NULL,
  creator = NULL, type = NULL, publisher = NULL, format = NULL,
  rights = NULL, contributor = NULL, provider = NULL, sp = NULL,
  sp_coordinates = NULL, sp_city = NULL, sp_county = NULL,
  sp_distance = NULL, sp_country = NULL, sp_code = NULL, sp_name = NULL,
  sp_region = NULL, sp_state = NULL, fields = NULL, sort_by = NULL,
  date = NULL, date_before = NULL, date_after = NULL, language = NULL,
  page_size = 100, page = NULL, facets = NULL, facet_size = 100,
  key = NULL, what = "table", ...)
}
\arguments{
\item{q}{(character) Query terms.}

\item{description}{(character) Object description.}

\item{title}{(character) Object title.}

\item{subject}{(character) Subject area}

\item{creator}{(character) Creator name}

\item{type}{(character) Type of object}

\item{publisher}{(character) Publisher}

\item{format}{(character) Format}

\item{rights}{(character) Rights}

\item{contributor}{(character) Contributor}

\item{provider}{(character) Provider}

\item{sp}{(character) Query all spatial fields.}

\item{sp_coordinates}{(character) Query only coordinates. Of the form
<latitude,longitude>}

\item{sp_city}{(character) Query by city name.}

\item{sp_county}{(character) Query by county name.}

\item{sp_distance}{(character) Distance from point defined in the
\code{sp_coordinates} field}

\item{sp_country}{(character) Query by location country}

\item{sp_code}{(character) Query by ISO 3166-2 country code. Codes are
included in this package, see \code{\link{country_codes}}. Find out more at
\url{https://www.iso.org/obp/ui/#search}.}

\item{sp_name}{(character) Location name.}

\item{sp_region}{(character) Name of a region, e.g., "Upstate New York"
(literal)}

\item{sp_state}{(character) ISO 3166-2 code for a U.S. state or territory}

\item{fields}{(character) A vector of the fields to return in the output.
The default is all fields. See \code{\link{dpla_fields}} for options.}

\item{sort_by}{(character) The default sort order is ascending. Most, but
not all fields can be sorted on. Attempts to sort on an un-sortable field
will return the standard error structure with a HTTP 400 status code.}

\item{date}{(character) A date}

\item{date_before}{(character) Date before}

\item{date_after}{(character) Date after}

\item{language}{(character) One of a name of a language, or an ISO-639 code.
Codes are included in this package, see \code{\link{language_codes}}.
Find out more at \url{http://www-01.sil.org/iso639-3/default.asp}.}

\item{page_size}{(integer) Number of items to return, defaults to 100.
Max of 500.}

\item{page}{(integer) Page number to return, defaults to NULL.}

\item{facets}{(character) Fields to facet on.}

\item{facet_size}{(integer) Default to 100, maximum 2000.}

\item{key}{(character) Your DPLA API key. See \code{\link{dpla_get_key}}}

\item{what}{(character) One of list or table (data.frame). (Default: table)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A list of length three:
\itemize{
 \item meta - metadata for the call, with one row and three columns:
  \itemize{
   \item found - number of records found matching criteria
   \item start - offset from record 1
   \item returned - number of records returned
  }
 \item data - tibble (data.frame) of results
 \item facets - list of same length as number of facets requested,
 each with a list of length two with a meta tibble/data.frame, and
 a data tibble/data.frame
}
}
\description{
Search items from the Digital Public Library of America (DPLA).
}
\details{
Note that parsing of results right now can lead to multiple
rows per record because sometimes an array of length > 1 for a result
makes a data.frame of more than one row per record. Thus, you will
get duplicated values in the \code{id} column of the results.
}
\examples{
\dontrun{
# Basic search, "fruit" in any fields
dpla_items(q="fruit")

# Limit records returned
dpla_items(q="fruit", page_size=2)

# Return certain fields
dpla_items(q="fruit", fields=c("id","publisher","format"))
dpla_items(q="fruit", fields="subject")

# Max is 500 per call, but you can use combo of page_size and page params
dpla_items(q="fruit", fields="id", page_size=500)$meta$returned
lapply(1:2, function(x) {
   dpla_items(q="fruit", fields="id", page_size=500, page=x)$meta$returned
})
out <- lapply(1:2, function(x) dpla_items(q="fruit", fields="id",
   page_size=500, page=x))
lapply(out, function(y) head(y$data))

# Search by date
out <- dpla_items(q="science", date_before=1900, page_size=200)
out$data

# Search by various fields
dpla_items(description="obituaries", page_size=2, fields="description")
dpla_items(title="obituaries", page_size=2, fields="title")
dpla_items(subject="yodeling", page_size=2, fields="subject")
dpla_items(creator="Holst-Van der Schalk", page_size=2, fields="creator")
dpla_items(type="text", page_size=2, fields="type")
dpla_items(publisher="Leningrad", page_size=2, fields="publisher")
dpla_items(rights="unrestricted", page_size=2, fields="rights")
dpla_items(provider="HathiTrust", page_size=2, fields="provider")

## don't seem to work
# dpla_items(contributor="Smithsonian", page_size=2, fields="contributor")
# dpla_items(format="Electronic resource", page_size=2, fields="format")

# Spatial search
## sp searches all spatial fields, or search on specific fields, see those
## params with sp_*
dpla_items(sp='Boston', page_size=2)
dpla_items(sp_state='Hawaii', page_size=2)
dpla_items(sp_state='Massachusetts OR Hawaii', page_size=2)
dpla_items(sp_coordinates='40,-100', page_size=2)
dpla_items(sp_country='Canada', page_size=2)
dpla_items(sp_county='Sacramento', page_size=2)

# Language search
dpla_items(language='Russian')$meta
dpla_items(language='rus')$meta
dpla_items(language='English')$meta

# Sorting
dpla_items(fields=c("id","title"), page_size=10)
dpla_items(fields=c("id","title"), page_size=10, sort_by="sourceResource.title")

# Faceting
dpla_items(facets="sourceResource.format", page_size=0)
dpla_items(facets="sourceResource.format", page_size=0, facet_size=5)
ids <- c("sourceResource.spatial.state","sourceResource.spatial.country")
dpla_items(facets=ids, page_size=0)
dpla_items(facets="sourceResource.type", page_size=0)
#dpla_items(facets="sourceResource.spatial.coordinates:42.3:-71", page_size=0)
#dpla_items(facets="sourceResource.temporal.begin", page_size=0)
dpla_items(facets="provider.name", page_size=0)
dpla_items(facets="isPartOf", page_size=0)
dpla_items(facets="hasView", page_size=0)
}
}

