% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpla_bulk.R
\name{dpla_bulk}
\alias{dpla_bulk}
\alias{dpla_bulk_list}
\title{Get bulk DPLA data}
\usage{
dpla_bulk(year, month, key, ...)

dpla_bulk_list(...)
}
\arguments{
\item{year}{(character) a year between 2015 and the current year}

\item{month}{(character) between 1 (January) and 12 (December)}

\item{key}{(character) a dataset name key, see Details.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
\code{dpla_bulk_list} returns the partial paths for JSON dataset dumps;
append the base URL \code{https://dpla-provider-export.s3.amazonaws.com} to the
beginning to get the full URL.
\code{dpla_bulk} returns a path to the compressed JSON file.
}
\description{
Get bulk DPLA data
}
\details{
All data in the DPLA repository are available for download
as gzipped JSON files. These include the standard DPLA fields, as well
as the complete record received from the partner.

See \url{https://digitalpubliclibraryofamerica.atlassian.net/wiki/spaces/TECH/pages/5931056/Database+export+files}
for description of the structure of the files

\code{dpla_bulk} doesn't attempt to read in the bulk JSON files as they can be
quite large - so we leave that to the user.
}
\section{Allowed Keys}{

\itemize{
\item all
\item artstor
\item bhl
\item cdl
\item david_rumsey
\item digital_commonwealth
\item digitalnc
\item esdn
\item georgia
\item getty
\item gpo
\item harvard
\item hathitrust
\item il
\item indiana
\item internet_archive
\item kdl
\item lc
\item maine
\item maryland
\item mdl
\item michigan
\item missouri_hub
\item mwdl
\item nara
\item nypl
\item pa
\item pennsylvania
\item scdl
\item smithsonian
\item tennessee
\item the_portal_to_texas_history
\item tn
\item uiuc
\item usc
\item virginia
\item washington
\item wisconsin
}
}

\examples{
\dontrun{
dpla_bulk(year = 2016, month = 4, key = "nypl")
res <- dpla_bulk(year = 2017, month = 1, key = "artstor")
}
}
