% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdpower.R
\name{rdpower}
\alias{rdpower}
\title{Power Calculations for RD Designs}
\usage{
rdpower(data = NULL, cutoff = 0, tau = NULL, alpha = 0.05,
  nsamples = NULL, sampsi = NULL, samph = NULL, all = FALSE,
  bias = NULL, variance = NULL, plot = FALSE, graph.range = NULL,
  covs = NULL, deriv = 0, p = 1, q = 2, h = NULL, b = NULL,
  rho = NULL, kernel = "triangular", bwselect = "mserd", vce = "nn",
  cluster = NULL, scalepar = 1, scaleregul = 1, fuzzy = NULL,
  level = 90)
}
\arguments{
\item{data}{a matrix (Y,R) containing the outcome variable and the running variable (as column vectors).}

\item{cutoff}{the RD cutoff (default is 0).}

\item{tau}{specifies the treatment effect under the alternative at which the power function is evaluated. The default is half the standard deviation of the outcome for the untreated group.}

\item{alpha}{specifies the significance level for the power function. Default is 0.05.}

\item{nsamples}{sets the total sample size to the left, sample size to the left inside the bandwidth, total sample size to the right and sample size to the right of the cutoff inside the bandwidth to calculate the variance when the running variable is not specified. When not specified, the values are calculated using the running variable.}

\item{sampsi}{sets the sample size at each side of the cutoff for power calculation. The first number is the sample size to the left of the cutoff and the second number is the sample size to the right. Default values are the sample sizes inside the chosen bandwidth.}

\item{samph}{sets the bandwidths at each side of the cutoff for power calculation. The first number is the bandwidth to the left of the cutoff and the second number is the bandwidth to the right.  Default values are the bandwidths used by \code{rdrobust}.}

\item{all}{displays the power using the conventional variance estimator, in addition to the robust bias corrected one.}

\item{bias}{set bias to the left and right of the cutoff. If not specified, the biases are estimated using \code{rdrobust}.}

\item{variance}{set variance to the left and right of the cutoff. If not specified, the variances are estimated using \code{rdrobust}.}

\item{plot}{plots the power function using the conventional and robust bias corrected standard errors from \code{rdrobust}.}

\item{graph.range}{range of the plot.}

\item{covs}{option for \code{rdrobust()}: specifies additional covariates to be used for estimation and inference.}

\item{deriv}{option for \code{rdrobust()}: specifies the order of the derivative of the regression functions to be estimated.}

\item{p}{option for \code{rdrobust()}: specifies the order of the local-polynomial used to construct the point-estimator.}

\item{q}{option for \code{rdrobust()}: specifies the order of the local-polynomial used to construct the bias-correction.}

\item{h}{option for \code{rdrobust()}: specifies the values of the main bandwidth to be used on the left and on the right of the cutoff, respectively.}

\item{b}{option for \code{rdrobust()}: specifies the values of the bias bandwidth $b$ to be used on the left and on the right of the cutoff, respectively.}

\item{rho}{option for \code{rdrobust()}: specifies the value of \code{rho} so that the bias bandwidth \code{b} equals \code{b=h/rho}.}

\item{kernel}{option for \code{rdrobust()}: kernel function used to construct the local-polynomial estimators.}

\item{bwselect}{option for \code{rdrobust()}: specifies the bandwidth selection procedure to be used.}

\item{vce}{option for \code{rdrobust()}: specifies the procedure used to compute the variance-covariance matrix estimator.}

\item{cluster}{option for \code{rdrobust()}: indicates the cluster ID variable used for the cluster-robust variance estimation with degrees-of-freedom weights.}

\item{scalepar}{option for \code{rdrobust()}: specifies scaling factor for RD parameter of interest.}

\item{scaleregul}{option for \code{rdrobust()}: specifies scaling factor for the regularization terms of bandwidth selectors.}

\item{fuzzy}{option for \code{rdrobust()}: specifies the treatment status variable used to implement fuzzy RD estimation.}

\item{level}{option for \code{rdrobust()}: sets the confidence level for confidence intervals.}
}
\value{
\item{power.rbc}{power against tau using robust bias corrected standard error}
\item{se.rbc}{robust bias corrected standard error}
\item{sampsi.r}{number of observations inside the window to the right of the cutoff}
\item{sampsi.l}{number of observations inside the window to the left of the cutoff}
\item{samph.r}{bandwidth to the right of the cutoff}
\item{samph.l}{bandwidth to the left of the cutoff}
\item{alpha}{significance level used in power function}
\item{tau}{treatment effect under alternative hypothesis}
\item{bias.r}{bias to the right of the cutoff}
\item{bias.l}{bias to the left of the cutoff}
\item{Vr.rb}{Robust bias corrected variance to the right of the cutoff}
\item{Vl.rb}{Robust bias corrected variance to the left of the cutoff}
\item{N.r}{Total sample size to the right of the cutoff}
\item{N.l}{Total sample size to the left of the cutoff}
\item{power.conv}{power against tau using conventional inference}
\item{se.conv}{conventional standard error}
}
\description{
\code{rdpower()} performs power calculations for RD designs.
}
\examples{
# Toy dataset
X <- array(rnorm(2000),dim=c(1000,2))
R <- X[,1] + X[,2] + rnorm(1000)
Y <- 1 + R -.5*R^2 + .3*R^3 + (R>=0) + rnorm(1000)
# Power against tau = 1
tmp <- rdpower(data=cbind(Y,R),tau=1)
# Power against tau = 1 including covariates
tmp <- rdpower(data=cbind(Y,R),tau=1,covs=X)


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2018). \href{https://sites.google.com/site/rdpackages/rdpower/Cattaneo-Titiunik-VazquezBare_2018_Stata.pdf}{Power Calculations for Regression Discontinuity Designs}. \emph{Working paper, University of Michigan}.
}
\author{
Matias Cattaneo, University of Michigan. \email{cattaneo@umich.edu}

Rocio Titiunik, University of Michigan. \email{titiunik@umich.edu}

Gonzalo Vazquez-Bare, University of Michigan. \email{gvazquez@umich.edu}
}
