% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.R
\name{get_net_cooccur_metrics}
\alias{get_net_cooccur_metrics}
\title{Retrieve co-occurrence network metrics for a play}
\usage{
get_net_cooccur_metrics(play = NULL, corpus = NULL, ...)
}
\arguments{
\item{play}{Character, name of a play (you can find all play names in
\code{"playName"} column within an object returned by
\code{\link{get_dracor}}). Character vector (longer than 1) is not
supported.}

\item{corpus}{Character, name of the corpus (you can find all corpus names in
\code{name} column within an object returned by
\code{\link{get_dracor_meta}}).}

\item{...}{Additional arguments passed to \code{\link{dracor_api}}.}
}
\value{
List with network metrics for a specific play.
}
\description{
\code{get_net_cooccur_metrics()} requests network metrics for a specific play,
given play and corpus names. Play network is constructed based on characters'
co-occurrence matrix.
}
\examples{
get_net_cooccur_metrics(play = "lessing-emilia-galotti", corpus = "ger")
}
\seealso{
\code{\link{get_net_cooccur_igraph}}
\code{\link{get_net_cooccur_gexf}} \code{\link{get_net_cooccur_graphml}}
\code{\link{get_net_cooccur_edges}} \code{\link{get_net_relations_igraph}}
}
