% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_acc.R
\name{drop_acc}
\alias{drop_acc}
\title{Get information about current Dropbox account.}
\usage{
drop_acc(dtoken = get_dropbox_token())
}
\arguments{
\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\value{
Nested list with elements \code{account_id},
  \code{name} (list), \code{email}, \code{email_verified}, \code{disabled},
  \code{locale}, \code{referral_link}, \code{is_paired}, \code{account_type}
  (list).

  If available, may also return \code{profile_photo_url},
  \code{country}, \code{team} (list), \code{team_member_id}.
}
\description{
Fields returned will vary by account;
}
\examples{
\dontrun{

  acc_info <- drop_acc()

  # extract display name
  acc_info$name$display_name
}
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#users-get_current_account}{API documentation}
}
