% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGT3X.R
\name{as.data.frame.activity}
\alias{as.data.frame.activity}
\title{Convert an activity matrix to a data.frame}
\usage{
\method{as.data.frame}{activity}(x, ..., verbose = FALSE, add_light = FALSE)
}
\arguments{
\item{x}{Object of class 'activity' (returned by read.gt3x)}

\item{...}{not used}

\item{verbose}{print diagnostic messages}

\item{add_light}{add light data to the \code{data.frame} if data exists in the
GT3X}
}
\value{
An object of class \code{activity_df} which is also a data.frame with
the following attributes (and more)
\itemize{
\item \code{subject_name} : Subject name from info file
\item \code{time_zone} : Time zone from info file
\item \code{missingness} : Data frame with timestamps and the number of missing values associated.
}
}
\description{
Convert an activity matrix to a data.frame
}
\seealso{
Other gt3x-parsers: 
\code{\link{parse_gt3x_info}()},
\code{\link{print.gt3x_info}()},
\code{\link{read.gt3x}()}
}
\concept{gt3x-parsers}
