% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{as.genalex}
\alias{as.genalex}
\alias{as.genalex.data.frame}
\alias{as.genalex.default}
\alias{as.genalex.genalex}
\alias{as.genalex.loci}
\title{Convert object to class 'genalex'}
\usage{
\method{as.genalex}{genalex}(x, force = FALSE, ...)

\method{as.genalex}{data.frame}(x, names = NULL, ploidy = 2, ...)

\method{as.genalex}{loci}(x, sep = "/", pop, ...)

\method{as.genalex}{default}(x, ...)
}
\arguments{
\item{x}{An object of class \code{'genalex'} or class
\code{'data.frame'}}

\item{force}{If \code{TRUE}, check for consistency between data and
annotations in \code{x} and recalculate and reset any inconsistent
attributes.  This option is only used if \code{x} has class
\code{'genalex'}, and is \code{FALSE} by default.}

\item{names}{A list of names to apply as accepted by \code{\link{genalex}}.
If any names are not provided, they are taken from the names of the
corresponding columns of \code{x}.  This option is only used if \code{x}
does not have class \code{'genalex'}.}

\item{ploidy}{Ploidy of the genotype columns in \code{x}
(\code{x[, 3:ncol(x)]}).  This option is only used if \code{x} does not
have class \code{'genalex'}.}

\item{sep}{Character separating joined alleles, if converting from
object of class \code{'loci'}}

\item{pop}{Populations to assign to samples if there is no
\code{population} column in the data}

\item{\dots}{Additional arguments, ignored unless \code{x} is of class
\code{'loci'} and if so passed to \code{\link{genalex}}}
}
\value{
\code{x} converted to a class \code{'genalex'} object
}
\description{
Converts object \code{x} to a data frame of class \code{'genalex'}.
There are seven cases:
\itemize{
  \item If \code{x} is of class \code{'genalex'}, it is simply returned.
  \item If \code{x} is of class \code{'genalex'} and \code{force = TRUE},
        \code{x} is examined for consistency between data and annotations,
        and any inconsistencies are recalculated based on the data.  To
        check whether inconsistencies exist, use
        \code{is.genalex(..., force = TRUE)} and add \code{verbose = TRUE}
        for descriptions of the inconsistencies.  Ploidy is taken from
        \code{x} and is not reset.  Attributes that may be reset include
        \code{n.samples}, \code{sample.title}, \code{n.loci},
        \code{locus.columns}, \code{locus.names}, \code{n.pops},
        \code{pop.labels}, \code{pop.sizes} and \code{pop.title}.
  \item If \code{x} is of class \code{'data.frame'}, it is examined to
        see if it might be a data frame created by an earlier version of
        the \code{readGenalex} package.  If so, it is converted to
        class \code{'genalex'} and returned.  Any other arguments are
        ignored.
  \item If \code{x} is of class \code{'data.frame'} and all columns from
        the third to the end are of class \code{\link[genetics]{genotype}},
        these columns are converted to class \code{'genalex'} genotypes,
        with one column per allele.  Once the alleles have been split,
        a call to \code{\link{genalex}} establishes the correct attributes.
  \item If \code{x} is of class \code{'data.frame'} but does not appear to
        be from an earlier version of \code{readGenalex} and does not
        have all genotype columns of class \code{\link[genetics]{genotype}},
        it is converted to class \code{'genalex'} using a call to
        \code{\link{genalex}} assuming a format identical to class
        \code{'genalex'}, where the first column holds sample names, the
        second column holds population names, and the remaining columns
        hold genotypes.
  \item If \code{x} is of class \code{'loci'}, it is converted using
        \code{\link{splitGenotypes}} and \code{\link{genalex}}.  Sample
        names are taken from the row names.  If there
        is no column in \code{x} named \code{"population"}, then the
        \code{pop} argument must be supplied as a substitute.  Additional
        non-genotype columns will likely result in an error.  No attempt
        is currently made to use the \code{"locicol"} attribute to narrow
        the conversion to only locus columns.  Furthermore, only diploid
        genotypes are currently handled.
  \item Any other class is an error.  Further conversions between genetic
        data formats may be added as additional methods.
}
If the object is not originally of class \code{'genalex'}, the
\code{"data.file.name"} attribute will reflect this function call.
}
\examples{
data(Qagr_adult_genotypes)
gt <- as.genalex(Qagr_adult_genotypes)
cat(attr(gt, "data.file.name"), "\\n")
gt.2 <- as.genalex(as.data.frame(Qagr_adult_genotypes))
cat(attr(gt.2, "data.file.name"), "\\n")
}
\author{
Douglas G. Scofield
}
\seealso{
\code{\link{is.genalex}}, \code{\link{genalex}}, \code{\link{splitGenotypes}}
}

