% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{reorderLoci}
\alias{reorderLoci}
\alias{reorderLoci.genalex}
\title{Reorder class \code{'genalex'} genotype columns}
\usage{
\method{reorderLoci}{genalex}(x, loci, ...)
}
\arguments{
\item{x}{An annotated data frame of class \code{'genalex'}}

\item{loci}{The names of loci found in \code{x}, in the desired new
            order.  All loci in \code{x} must be named, and no loci
            may be duplicated.  The order of
            the alleles within each locus is preserved.}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
A data frame of class \code{'genalex'} containing the same
genotype data from \code{x} reordered according to \code{loci}.
}
\description{
Reorder the genotype columns of a class \code{'genalex'} object by locus.
}
\examples{
data(Qagr_adult_genotypes)
# reverse loci
loci <- rev(attr(Qagr_adult_genotypes, "locus.names"))
reord = reorderLoci(Qagr_adult_genotypes, rev(loci))
}
\author{
Douglas G. Scofield
}

