% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_md_table.R
\name{read_md_table}
\alias{read_md_table}
\title{Read a Markdown Table into a Tibble}
\usage{
read_md_table(file, warn = TRUE, ...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or
literal data (either a single string or a raw vector).
Files starting with \verb{http://}, \verb{https://}, \verb{ftp://},
or \verb{ftps://} will be automatically downloaded.}

\item{warn}{Boolean. Should \code{read_md_table} warn
about possible issues with the passed \code{file}?
Defaults to \code{TRUE}.}

\item{...}{Arguments passed on to \code{\link[readr:read_delim]{readr::read_delim}}.}
}
\value{
A tibble created from the markdown table.
}
\description{
Read a Markdown Table into a Tibble
}
\details{
\code{read_md_table} reads a markdown table into
a tibble from a string, file, or URL. It uses
\code{\link[readr:read_delim]{readr::read_delim}} to efficiently read in
data.

If \code{warn} is \code{TRUE}, \code{read_md_table} will warn if
there are potential issues with the provided
markdown table. Depending on the issue,
\code{read_md_table} may still correctly read the table.
For instance, if the row separating the header from
the other rows is malformed or any rows have missing
leading or trailing pipes, warnings will be raised
but the data will be read correctly.
\code{\link[readr:read_delim]{readr::read_delim}} will provide its own warnings
if there are potential issues.
}
\examples{
# Read from a file
read_md_table(read_md_table_example("mtcars.md"))

# Read from a string
read_md_table("| H1 | H2 | \n|-----|-----|\n| R1C1 | R1C2 |\n| R2C1 | R2C2 |")

\donttest{
# Read from a URL
read_md_table(
  "https://raw.githubusercontent.com/jrdnbradford/readMDTable/main/inst/extdata/iris.md"
)
}

# Get warnings for malformed tables
read_md_table(
  "| Name  | Age | City        | Date       |
   |-------|-----|-------------|------------|
   | Alice | 30  | New York    | 2021/01/08 |
   | Bob   | 25  | Los Angeles | 2023/07/22 |
     Carol | 27  | Chicago     | 2022/11/01  "
)
}
