% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{readl}
\alias{readl}
\title{Read \bold{lines} from file/webpage}
\usage{
readl(.x, first = 1, last = -1)
}
\arguments{
\item{.x}{Path to file or URL}

\item{first}{The first (starting) line number in which reading should start (inclusive). Defaults to 1.}

\item{last}{The last (ending) line number in which reading should end (inclusive). To ensure the reading of all possible lines, set this value to less than 1 (0 or -1). Defaults to -1.}
}
\value{
A vector of lines read from input
}
\description{
Returns \bold{lines} of text/source from file or URL
}
\examples{

## create a temp file containing multiple lines of text
tmp <- tempfile()
cat("TITLE", "", "By", "", "Some more text here", "",
  "last line", sep = "\\n", file = tmp)

## read all lines of tmp
readl(tmp)

## read first three lines
readl(tmp, 1, 3)

## read lines 3-5
readl(tmp, 3, 5)

## cleanup
unlink(tmp)

}
\seealso{
Other read: \code{\link{read}}
}
\concept{read}
