% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/positioning.R
\name{position_max}
\alias{position_max}
\title{Positions the highest values with values decreasing around it}
\usage{
position_max(data, col = NULL, position = NULL, shuffle_sides = FALSE)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{col}{Column to create sorting factor by. When \code{NULL} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{position}{Index or quantile (in \code{0-1}) at which to position the element of interest.}

\item{shuffle_sides}{Whether to shuffle which elements are left and right of the position. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

The highest value is positioned at the given index/quantile with the other
values decreasing around it.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4, }\strong{\code{5}}\code{)}

and \code{position = 2}

are \strong{ordered as}:

\code{c(3,} \strong{\code{5}}\code{, 4, 2, 1)}
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "index" = 1:10,
  "A" = sample(1:10),
  "B" = runif(10),
  "C" = LETTERS[1:10],
  "G" = c(
    1, 1, 1, 2, 2,
    2, 3, 3, 3, 3
  ),
  stringsAsFactors = FALSE
)

# Position the highest index (row number)
position_max(df, position = 3)$index
position_max(df, position = 8)$index

# Position the maximum value in each of the columns
position_max(df, col = "A", position = 3)$A
position_max(df, col = "B", position = 3)$B
position_max(df, col = "C", position = 3)$C

# Randomize which elements are left and right of the position
position_max(df, col = "A", position = 3, shuffle_sides = TRUE)$A

# Grouped by G
df \%>\%
  dplyr::select(G, A) \%>\% # For clarity
  dplyr::group_by(G) \%>\%
  position_max(col = "A", position = 2)

# Plot the rearranged values
plot(x = 1:10, y = position_max(df, col = "B", position = 3)$B)
plot(x = 1:10, y = position_max(df, col = "B", position = 3, shuffle_sides = TRUE)$B)
}
\seealso{
Other rearrange functions: 
\code{\link{center_max}()},
\code{\link{center_min}()},
\code{\link{closest_to}()},
\code{\link{furthest_from}()},
\code{\link{pair_extremes}()},
\code{\link{position_min}()},
\code{\link{rev_windows}()},
\code{\link{roll_elements}()},
\code{\link{shuffle_hierarchy}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{rearrange functions}
