% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midrange.R
\name{midrange}
\alias{midrange}
\title{Find the midrange values}
\usage{
midrange(..., cols = NULL, na.rm = FALSE)
}
\arguments{
\item{...}{\code{Numeric vectors} or a single \code{data.frame}.}

\item{cols}{Names of columns to use when \code{`...`} is a single \code{data.frame}.}

\item{na.rm}{Whether to ignore missing values when calculating
\code{min} and \code{max} values. (Logical)}
}
\value{
Either a \code{vector} with the midrange of each supplied \code{vector}
or a \code{data.frame} with the midrange of each supplied column along with any grouping variables.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Calculates the midrange for each of the passed \code{vectors}/\code{columns}.

Midrange is defined as:
\deqn{(max x + min x) / 2}
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create three vectors
x <- runif(10)
y <- runif(10)
z <- runif(10)

# Find midrange for each vector
midrange(x, y, z)

#
# For data.frames
#

# Create data frame
df <- data.frame(
  "x" = x,
  "y" = y,
  "z" = z,
  "g" = rep(1:2, each = 5)
)

# Find midrange for each column
midrange(df, cols = c("x", "y", "z"))

# When 'df' is grouped
df \%>\%
  dplyr::group_by(g) \%>\%
  midrange(cols = c("x", "y", "z"))
}
\seealso{
Other coordinate functions: 
\code{\link{centroid}()},
\code{\link{create_origin_fn}()},
\code{\link{is_most_centered}()},
\code{\link{most_centered}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{coordinate functions}
