% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{exactly}
\alias{exactly}
\title{Make a regex exact}
\usage{
exactly(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Makes a regex exact: that is, it must contain the whole string, not just part
of it.
}
\examples{
# A hex color
(rx <- "#" \%R\% hex_digit(6))
(rx_exact <- exactly(rx))

# Usage
stringi::stri_detect_regex("ginger is #B06500", rx)
stringi::stri_detect_regex("ginger is #B06500", rx_exact)
stringi::stri_detect_regex("#B06500", rx_exact)
}

