% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDarroch.R
\name{NDarroch}
\alias{NDarroch}
\title{Spatially or Temporally Stratified Abundance Est (Darroch)}
\usage{
NDarroch(
  n1counts,
  n2counts,
  m2strata1 = NULL,
  m2strata2 = NULL,
  stratamat = NULL
)
}
\arguments{
\item{n1counts}{A vector of the total sample sizes in the first event, by
strata.  For example, setting \code{n1counts=c(20,30,40)} would imply 20
individuals captured and marked in stratum 1, 30 in stratum 2, and 40 in
stratum 3.}

\item{n2counts}{A vector of the total sample sizes in the second event, by
strata.}

\item{m2strata1}{A vector of the first-event stratum membership of each
recaptured individual.  Only values \code{1, 2, 3, ...} are allowed.  May
be used together with \code{m2strata2} instead of \code{stratamat}.}

\item{m2strata2}{A vector of the second-event stratum membership of each
recaptured individual.  Only values \code{1, 2, 3, ...} are allowed.  May
be used together with \code{m2strata1} instead of \code{stratamat}.}

\item{stratamat}{A matrix specifying the number of recaptures in each
combination of event 1 and event 2 strata, with rows corresponding to event
1 strata and columns corresponding to event 2 strata.  May be used instead
of \code{m2strata1} and \code{m2strata2}.}
}
\value{
A numeric list, giving the strata matrix if originally given in vector form, abundance estimates and standard errors by event 1 and event 2 strata, and the total abundance estimate and standard error.
}
\description{
Computes abundance estimates and associated variance in the event of spatial or temporal stratification, or in any stratification in which individuals can move between strata.  Marking (event 1) and recapture (event 2) strata do not need to be the same.

Inputs are vectors of total event 1 and 2 sample sizes, and either vectors of event 1 and 2 strata corresponding to each recaptured individual, or a matrix of total number of recaptures for each combination of event 1 and event 2 strata.

Implementation is currently using Darroch's method, and will only accept non-singular input matrices.
}
\examples{
mat <- matrix(c(59,30,1,45,280,38,0,42,25), nrow=3, ncol=3, byrow=TRUE)

NDarroch(n1counts=c(484,1468,399), n2counts=c(847,6616,2489), stratamat=mat)
}
\references{
Darroch, J.N. (1961). The two-sample capture-recapture census when tagging and sampling are stratified.  \emph{Biometrika} \strong{48}, 241-60.
}
\seealso{
\link{consistencytest}
}
\author{
Matt Tyers
}
