% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{step_pls}
\alias{step_pls}
\alias{tidy.step_pls}
\title{Partial Least Squares Feature Extraction}
\usage{
step_pls(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  num_comp = 2,
  predictor_prop = 1,
  outcome = NULL,
  options = list(scale = TRUE),
  preserve = FALSE,
  res = NULL,
  prefix = "PLS",
  skip = FALSE,
  id = rand_id("pls")
)

\method{tidy}{step_pls}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will be
used to compute the dimensions. See \code{\link[=selections]{selections()}} for more details. For the
\code{tidy} method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned?. By default, the function assumes that the new dimension
columns created by the original variables will be used as predictors in a
model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{num_comp}{The number of pls dimensions to retain as new predictors.
If \code{num_comp} is greater than the number of columns or the number of
possible dimensions, a smaller value will be used.}

\item{predictor_prop}{The maximum number of original predictors that can have
non-zero coefficients for each PLS component (via regularization).}

\item{outcome}{When a single outcome is available, character
string or call to \code{\link[dplyr:vars]{dplyr::vars()}} can be used to specify a single outcome
variable.}

\item{options}{A list of options to \code{mixOmics::pls()}, \code{mixOmics::spls()},
\code{mixOmics::plsda()}, or \code{mixOmics::splsda()} (depending on the data and
arguments).}

\item{preserve}{A single logical: should the original predictor data be
retained along with the new features?}

\item{res}{A list of results are stored here once this preprocessing step
has be trained by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. See notes below.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_pls} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected), \code{components}, and \code{values}.
}
\description{
\code{step_pls} creates a \emph{specification} of a recipe step that will
convert numeric data into one or more new dimensions.
}
\details{
PLS is a supervised version of principal component
analysis that requires the outcome data to compute
the new features.

This step requires the Bioconductor \pkg{mixOmics} package. If not installed, the
step will stop with a note about installing the package.

The argument \code{num_comp} controls the number of components that will
be retained (the original variables that are used to derive the
components are removed from the data). The new components will
have names that begin with \code{prefix} and a sequence of numbers.
The variable names are padded with zeros. For example, if \code{num_comp < 10}, their names will be \code{PLS1} - \code{PLS9}. If \code{num_comp = 101}, the
names would be \code{PLS001} - \code{PLS101}.

Sparsity can be encouraged using the \code{predictor_prop} parameter. This affects
each PLS component, and indicates the maximum proportion of predictors with
non-zero coefficients in each component. \code{step_pls()} converts this
proportion to determine the \code{keepX} parameter in \code{mixOmics::spls()} and
\code{mixOmics::splsda()}. See the references in \code{mixOmics::spls()} for details.

The \code{tidy()} method returns the coefficients that are usually defined as

\deqn{W(P'W)^{-1}}

(See the Wikipedia article below)

When applied to data, these values are usually scaled by a column-specific
norm. The \code{tidy()} method applies this same norm to the coefficients shown
above.
}
\examples{
# requires the Bioconductor mixOmics package
data(biomass, package = "modeldata")

biom_tr <-
  biomass \%>\%
  dplyr::filter(dataset == "Training") \%>\%
  dplyr::select(-dataset,-sample)
biom_te <-
  biomass \%>\%
  dplyr::filter(dataset == "Testing")  \%>\%
  dplyr::select(-dataset,-sample,-HHV)

dense_pls <-
  recipe(HHV ~ ., data = biom_tr) \%>\%
  step_pls(all_predictors(), outcome = "HHV", num_comp = 3)

sparse_pls <-
  recipe(HHV ~ ., data = biom_tr) \%>\%
  step_pls(all_predictors(), outcome = "HHV", num_comp = 3, predictor_prop = 4/5)

## -----------------------------------------------------------------------------
## PLS discriminant analysis

data(cells, package = "modeldata")

cell_tr <-
  cells \%>\%
  dplyr::filter(case == "Train") \%>\%
  dplyr::select(-case)
cell_te <-
  cells \%>\%
  dplyr::filter(case == "Test")  \%>\%
  dplyr::select(-case,-class)

dense_plsda <-
  recipe(class ~ ., data = cell_tr) \%>\%
  step_pls(all_predictors(), outcome = "class", num_comp = 5)

sparse_plsda <-
  recipe(class ~ ., data = cell_tr) \%>\%
  step_pls(all_predictors(), outcome = "class", num_comp = 5, predictor_prop = 1/4)

}
\references{
\url{https://en.wikipedia.org/wiki/Partial_least_squares_regression}

Rohart F, Gautier B, Singh A, Lê Cao K-A (2017) \emph{mixOmics: An R package for
'omics feature selection and multiple data integration}. PLoS Comput Biol
13(11): e1005752. \url{https://doi.org/10.1371/journal.pcbi.1005752}
}
\seealso{
\code{\link[=step_pca]{step_pca()}}, \code{\link[=step_kpca]{step_kpca()}}, \code{\link[=step_ica]{step_ica()}}, \code{\link[=recipe]{recipe()}},
\code{\link[=prep.recipe]{prep.recipe()}}, \code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{pls}
\concept{preprocessing}
\concept{projection_methods}
\keyword{datagen}
