% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colcheck.R
\name{check_cols}
\alias{check_cols}
\alias{tidy.check_cols}
\title{Check if all Columns are Present}
\usage{
check_cols(recipe, ..., role = NA, trained = FALSE, skip = FALSE,
  id = rand_id("cols"))

\method{tidy}{check_cols}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The check will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are checked in the check See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this check since no new variables are
created.}

\item{trained}{A logical for whether the selectors in \code{...}
have been resolved by \code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the check be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{check_cols} object.}
}
\description{
\code{check_cols} creates a \emph{specification} of a recipe
step that will check if all the columns of the training frame are
present in the new data.
}
\details{
This check will break the \code{bake} function if any of the checked
columns does contain \code{NA} values. If the check passes, nothing is changed
to the data.
}
\examples{

data(biomass)

biomass_rec <- recipe(HHV ~ ., data = biomass) \%>\%
   step_rm(sample, dataset) \%>\%
   check_cols(contains("gen")) \%>\%
   step_center(all_predictors())

\dontrun{
bake(biomass_rec, biomass[, c("carbon", "HHV")])
}
}
