% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_collect.R
\name{cluster_collect}
\alias{cluster_collect}
\title{Collect pairs from cluster nodes}
\usage{
cluster_collect(pairs, select = NULL, clear = FALSE)
}
\arguments{
\item{pairs}{an object or type \code{cluster_pairs} as created for example by
\code{\link{cluster_pair}}.}

\item{select}{the name of a logical column that is used to select the pairs
that will be collected}

\item{clear}{remove the pairs from the cluster nodes}
}
\value{
Returns an object of type \code{pairs} which is a \code{data.table}. This
object can be used as a regular (non-cluster) set of pairs
}
\description{
Collect pairs from cluster nodes
}
\examples{
library(parallel)
data("linkexample1", "linkexample2")
cl <- makeCluster(2)
\dontshow{clusterEvalQ(cl, data.table::setDTthreads(1))}

pairs <- cluster_pair(cl, linkexample1, linkexample2)
local_pairs <- cluster_collect(pairs, clear = FALSE)

compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
model <- problink_em(~ lastname + firstname + address + sex, data = pairs)
predict(model, pairs, type = "mpost", add = TRUE, binary = TRUE)
# Select pairs with a mpost > 0.5
select_threshold(pairs, "selected", "mpost", 0.5)
# Collect the selected pairs
local_pairs <- cluster_collect(pairs, "selected")

stopCluster(cl)
}
