% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{event_time}
\alias{event_time}
\title{calculate the time between each event in a session, or set of sessions}
\usage{
event_time(sessions, as_vector = TRUE, fun, ...)
}
\arguments{
\item{sessions}{a list of sessions, generated with \code{\link{reconstruct_sessions}}}

\item{as_vector}{whether to unlist the results and return them as a vector,
or return them as a list. Set to TRUE (vector) by default. In the event that you
are setting a value for "fun", your choice may impact the way the function
operates over the results}

\item{fun}{an optional parameter indicating a function to pass over the results,
before they are returned.}

\item{...}{optional arguments to pass to fun}
}
\value{
a list, a vector, or the output format of \code{fun}
}
\description{
As well as \code{\link{session_length}}, which calculates the length
of a session, \code{event_time} extracts the length of time between each event
(which can be used for purposes such as counting the likely time-on-page, in the
context of web analytics). It allows you to customise
the output format and optionally run analytical functions against
the results before they are returned.
}
\examples{
#Load, convert timestamps to seconds, split
data("session_dataset")
session_dataset$timestamp <- to_seconds(x = session_dataset$timestamp, format = "\%Y\%m\%d\%H\%M\%S")
events_by_user <- split(session_dataset$timestamp, session_dataset$UUID)
sessions <- reconstruct_sessions(events_by_user)

#Extract the time between events, separating out the results for each session
list_event_time <- event_time(sessions, as_vector = FALSE)

#Extract the arithmetic mean time between events
mean_event_time <- event_time(sessions, as.vector = TRUE, fun = mean, trim = 0.5)

}
\seealso{
\code{\link{session_length}} for calculating the length of time
spent within a session
}

