% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{session_length}
\alias{session_length}
\title{Calculate session length}
\usage{
session_length(sessions)
}
\arguments{
\item{sessions}{a dataset of sessions, presumably generated with
\code{\link{sessionise}}.}
}
\value{
a data.frame of two columns - \code{session_id}, containing unique
session IDs, and \code{session_length}, containing the length (in seconds)
of that particular session.

Please note that these lengths should be considered a \emph{minimum};
because of how sessions behave, calculating the time-on-page of the last
event in a session is impossible.
}
\description{
Calculate the overall length of each session.
}
\examples{
#Load and sessionise the dataset
data("session_dataset")
sessions <- sessionise(session_dataset, timestamp, uuid)

# Calculate session length
len <- session_length(sessions)

}
\seealso{
\code{\link{sessionise}} for session reconstruction, and
\code{\link{time_on_page}}, \code{\link{session_count}} and
\code{\link{bounce_rate}} for other session-related metrics.
}
