% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RecoSys.R
\name{tune}
\alias{tune}
\title{Tuning Model Parameters}
\arguments{
\item{r}{Object returned by \code{\link{Reco}}().}

\item{train_path}{Path to the traning data file, same as the one in
\code{$\link{train}()}. See the help page there for the
details about the data format.}

\item{opts}{A number of candidate tuning parameter values and extra options in the
            model tuning procedure. See section \strong{Parameters and Options}
            for details.}
}
\value{
A list with two components:

\describe{
  \item{\code{min}}{Parameter values with minimum cross validation RMSE. This
                    is a list that can be passed to the \code{opts} argument
                    in \code{$\link{train}()}.}
  \item{\code{res}}{A data frame giving the supplied candidate
                    values of tuning parameters, and one column showing the
                    RMSE associated with each combination.}
}
}
\description{
This method is a member function of class "\code{RecoSys}"
that uses cross validation to tune the model parameters.

The common usage of this method is
\preformatted{r = Reco()
r$tune(train_path, opts = list(dim = c(10, 15, 20),
                               cost = c(0.01, 0.1),
                               lrate = c(0.01, 0.1))
)}
}
\section{Parameters and Options}{

The \code{opts} argument should be a list that provides the candidate values
of tuning parameters and some other options. For tuning parameter (\code{dim},
\code{cost} or \code{lrate}), users can provide a numeric vector, so that
the model will be evaluated on each combination of the candidate values.
For other non-tuning options, users should give a single value. If a parameter
or option is not set by the user, the program will use a default one.

See below for the list of available parameters and options:

\describe{
\item{\code{dim}}{Tuning parameter, the number of latent factors.
                  Can be specified as an integer vector, with default value
                  \code{c(10, 15, 20)}.}
\item{\code{cost}}{Tuning parameter, the regularization cost for latent factors.
                   Can be specified as a numeric vector, with default value
                   \code{c(0.01, 0.1)}.}
\item{\code{lrate}}{Tuning parameter, the learning rate, which can be thought
                    of as the step size in gradient descent.
                    Can be specified as a numeric vector, with default value
                    \code{c(0.01, 0.1)}.}
\item{\code{nfold}}{Integer, the number of folds in cross validation. Default is 5.}
\item{\code{niter}}{Integer, the number of iterations. Default is 20.}
\item{\code{nthread}}{Integer, the number of threads for parallel
                      computing. Default is 1.}
\item{\code{nmf}}{Logical, whether to perform non-negative matrix factorization.
                  Default is \code{FALSE}.}
\item{\code{verbose}}{Logical, whether to show detailed information. Default is
                      \code{FALSE}.}
}
}
\examples{
\dontrun{trainset = system.file("dat", "smalltrain.txt", package = "recosystem")
r = Reco()
set.seed(123) # This is a randomized algorithm
res = r$tune(
    trainset,
    opts = list(dim = c(10, 20, 30), lrate = c(0.05, 0.1, 0.2), nthread = 2)
)
r$train(trainset, opts = res$min)
}
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
\references{
W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
ACM TIST, 2015.

W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A learning-rate schedule for stochastic gradient methods to matrix factorization.
PAKDD, 2015.
}
\seealso{
\code{$\link{train}()}
}

