% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSource.R
\name{data_source}
\alias{data_source}
\alias{data_file}
\alias{data_memory}
\alias{data_matrix}
\title{Specifying Data Source}
\usage{
data_file(path, index1 = FALSE, ...)

data_memory(user_index, item_index, rating = NULL, index1 = FALSE, ...)

data_matrix(mat, ...)
}
\arguments{
\item{path}{Path to the data file.}

\item{index1}{Whether the user indices and item indices start with 1
(\code{index1 = TRUE}) or 0 (\code{index1 = FALSE}).}

\item{\dots}{Currently unused.}

\item{user_index}{An integer vector giving the user indices of rating scores.}

\item{item_index}{An integer vector giving the item indices of rating scores.}

\item{rating}{A numeric vector of the observed entries in the rating matrix.
Can be specified as \code{NULL} for testing data, in which case
it is ignored.}

\item{mat}{A \code{dgTMatrix} (if it has ratings/values) or \code{ngTMatrix}
(if it is binary) sparse matrix, with users corresponding to rows
and items corresponding to columns.}
}
\value{
An object of class "DataSource" as required by
\code{$\link{tune}()}, \code{$\link{train}()}, and \code{$\link{predict}()}.
}
\description{
Functions in this page are used to specify the source of data in the recommender system.
They are intended to provide the input argument of functions such as
\code{$\link{tune}()}, \code{$\link{train}()}, and \code{$\link{predict}()}.
Currently three data formats are supported: data file (via function \code{data_file()}),
data in memory as R objects (via function \code{data_memory()}), and data stored as a
sparse matrix (via function \code{data_matrix()}).
}
\details{
In \code{$\link{tune}()} and \code{$\link{train}()}, functions in this page
are used to specify the source of training data.

\code{data_file()} expects a text file that describes a sparse matrix
in triplet form, i.e., each line in the file contains three numbers
\preformatted{row col value}
representing a number in the rating matrix
with its location. In real applications, it typically looks like
\preformatted{user_index item_index rating}
The \file{smalltrain.txt} file in the \file{dat} directory of this package
shows an example of training data file.

If the sparse matrix is given as a \code{dgTMatrix} or \code{ngTMatrix} object
(triplets/COO format defined in the \pkg{Matrix} package), then the function
\code{data_matrix()} can be used to specify the data source.

If user index, item index, and ratings are stored as R vectors in memory,
they can be passed to \code{data_memory()} to form the training data source.

By default the user index and item index start with zeros, and the option
\code{index1 = TRUE} can be set if they start with ones.

From version 0.4 \pkg{recosystem} supports two special types of matrix
factorization: the binary matrix factorization (BMF), and the one-class
matrix factorization (OCMF). BMF requires ratings to take value from
\eqn{{-1, 1}}, and OCMF requires all the ratings to be positive.

In \code{$\link{predict}()}, functions in this page provide the source of
testing data. The testing data have the same format as training data, except
that the value (rating) column is not required, and will be ignored if it is
provided. The \file{smalltest.txt} file in the \file{dat} directory of this
package shows an example of testing data file.
}
\seealso{
\code{$\link{tune}()}, \code{$\link{train}()}, \code{$\link{predict}()}
}
\author{
Yixuan Qiu <\url{https://statr.me}>
}
