% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{map.easy}
\alias{map.easy}
\title{Species distributions made easy (multiple species).}
\usage{
map.easy(longlat, layers = NULL, habitat = NULL, zone = NULL,
  thin = TRUE, error = NULL, move = TRUE, dem = NULL, pca = 0,
  filename = NULL, mapoption = NULL, testpercentage = 0, mintest = 20,
  runs = 0, subset = 0)
}
\arguments{
\item{longlat}{data.frame of taxon names, longitude and latitude or eastness and northness (three columns in this order) of each occurrence record.}

\item{layers}{If NULL analyses are done with environmental layers read from data files of red.setup(). If a Raster* object as defined by package raster, analyses use these.}

\item{habitat}{Raster* object as defined by package raster. Habitat extent layer (0/1) used instead of layers if any species is an habitat specialist.}

\item{zone}{UTM zone if data is in metric units. Used only for correct placement of kmls and countries.}

\item{thin}{boolean defining if species data should be thinned before modeling (only for SDMs).}

\item{error}{Vector of spatial error in longlat (one element per row of longlat) in the same unit as longlat. Used to move any point randomly within the error radius.}

\item{move}{If TRUE, identifies and moves presence records to closest cells with environmental data. Use when spatial error might put records outside such data.}

\item{dem}{RasterLayer object. It should be a digital elevation model for calculation of elevation limits of the species. If NULL, dem from red.setup() is used if possible, otherwise it will be 0.}

\item{pca}{Number of pca axes for environmental data reduction. If 0 (default) no pca is made.}

\item{filename}{Name of output csv file with all results. If NULL it is named "Results_All.csv".}

\item{mapoption}{Vector of values within options: points, habitat and sdm; each value corresponding to the function to be used for each species (map.points, map.habitat, map.sdm). If a single value, all species will be modelled according to it. If NULL, the function will perform analyses using map.points. Species values must be in same order as latlong.}

\item{testpercentage}{Percentage of records used for testing only. If 0 all records will be used for both training and testing.}

\item{mintest}{Minimim number of total occurrence records of any species to set aside a test set. Only used if testpercentage > 0.}

\item{runs}{If <= 0 no ensemble modelling is performed. If > 0, ensemble modelling with n runs is made. For each run, a new random sample of occurrence records (if testpercentage > 0), background points and predictive variables (if subset > 0) are chosen. In the ensemble model, each run is weighted as max(0, (runAUC - 0.5)) ^ 2.}

\item{subset}{Number of predictive variables to be randomly selected from layers for each run if runs > 0. If <= 0 all layers are used on all runs. Using a small number of layers is usually better than using many variables for rare species, with few occurrence records (Lomba et al. 2010, Breiner et al. 2015).}
}
\value{
Outputs maps in asc, pdf and kml format, plus a file with EOO, AOO and a list of countries where the species is predicted to be present if possible to extract.
}
\description{
Single step for prediction of multiple species distributions. Output of maps (in pdf format), klms (for Google Earth) and relevant data (in csv format).
}
\references{
Breiner, F.T., Guisan, A., Bergamini, A., Nobis, M.P. (2015) Overcoming limitations of modelling rare species by using ensembles of small models. Methods in Ecology and Evolution, 6: 1210-1218.

Lomba, A., Pellissier, L., Randin, C.F., Vicente, J., Moreira, F., Honrado, J., Guisan, A. (2010) Overcoming the rare species modelling paradox: a novel hierarchical framework applied to an Iberian endemic plant. Biological Conservation, 143: 2647-2657.
}
