#' @name deprecated_redcapProjectInfo
#' @title Deprecated Functions
#' @description The \code{redcapProjectInfo} function has been deprecated to avoid
#'   confusion with the API method now executed by \code{exportProjectInformation}.
#'   The replacement function is \code{\link{exportBundle}}.
#'   
#' @param rcon A REDCap connection object as generated by \code{redcapConnection}
#' @param date Logical. If \code{TRUE}, user expiration dates are converted to 
#'   \code{POSIXct} objects.
#' @param label Logical.  If \code{TRUE}, the user form permissions are 
#'   converted to labelled factors.
#' @param meta_data Logical.  Indicates if the meta data (data dictionary) 
#'   should be exported.
#' @param users Logical. Indicates if the users table should be exported.
#' @param instruments Logical. Indicates if the instruments table should be exported.
#' @param events Logical. Indicates if the event names should be exported.
#' @param arms Logical. Indicates if the arms table should be exported.
#' @param mappings Logical. Indicates if the form-event mappings should 
#'   be exported.
#' @param version Indicates if the REDCap version number should be exported.  
#'   Only applicable in REDCap 6.0.0 and higher.
#' @param ... Arguments to be passed to other methods
#' @param v.number A character string given the desired version number should the
#'  API method not be available.
#'   
#' @aliases redcapProjectInfo
#' @aliases redcapProjectInfo.redcapApiConnection
#' @aliases redcapProjectInfo.redcapDbConnection
#' @export redcapProjectInfo
#' 

redcapProjectInfo <- function(rcon, date=TRUE, label=TRUE, 
                              meta_data=TRUE, users=TRUE, instruments=TRUE,
                              events=TRUE, arms=TRUE, mappings=TRUE,
                              version=TRUE, ...) UseMethod("redcapProjectInfo")

#' @rdname deprecated_redcapProjectInfo
#' @export

redcapProjectInfo.redcapDbConnection <- function(rcon, date=TRUE, label=TRUE, 
                                                 meta_data=TRUE, users=TRUE, instruments=TRUE,
                                                 events=TRUE, arms=TRUE, mappings=TRUE,
                                                 version=TRUE, ...){
  message("The 'redcapDbConnection' methods have been deprecated. ",
          "Please use the 'redcapApiConnection' methods.")
  message("'redcapProjectInfo' has been deprected.  Please use 'exportBundle'")
}

#' @rdname deprecated_redcapProjectInfo
#' @export

redcapProjectInfo.redcapApiConnection <- function(rcon, date=TRUE, label=TRUE, 
                                                  meta_data=TRUE, users=TRUE, instruments=TRUE,
                                                  events=TRUE, arms=TRUE, mappings=TRUE,
                                                  version=TRUE, ...,
                                                  v.number = ""){
  
  message("'redcapProjectInfo' has been deprected.  Please use 'exportBundle'")
  exportBundle.redcapApiConnection(rcon, date, label, meta_data,
                                   users, instruments, events, arms, mappings,
                                   version, ..., v.number = "")
  
}