% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteEvents.R
\name{deleteEvents}
\alias{deleteEvents}
\title{Delete Events from a Project}
\usage{
deleteEvents(
  rcon,
  events = NULL,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

deleteEvents(
  rcon,
  events = NULL,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{events}{\code{character} vector giving the unique event names
of the events to be deleted.}

\item{refresh}{\code{logical(1)} If \code{TRUE}, cached event data will be 
refreshed after the deletion.}

\item{...}{Additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This method allows you to delete Events from a project.
  Notice: Because of this method's destructive nature, it is only 
  available for use for projects in Development status. Additionally, 
  please be aware that deleting an event will automatically delete 
  any records/data that have been collected under that event 
  (this is non-reversible data loss).
}
