% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsRecordsTypedMethods.R,
%   R/exportRecordsTyped.R, R/exportReportsTyped.R
\name{recordsTypedMethods}
\alias{recordsTypedMethods}
\alias{exportRecordsTyped}
\alias{exportReportsTyped}
\alias{exportRecordsTyped.redcapApiConnection}
\alias{exportRecordsTyped.redcapOfflineConnection}
\alias{exportReportsTyped.redcapApiConnection}
\title{Export Records or Reports From a Project}
\usage{
exportRecordsTyped(
  rcon,
  fields = NULL,
  drop_fields = NULL,
  forms = NULL,
  records = NULL,
  events = NULL,
  ...
)

exportReportsTyped(rcon, report_id, ...)

\method{exportRecordsTyped}{redcapApiConnection}(
  rcon,
  fields = NULL,
  drop_fields = NULL,
  forms = NULL,
  records = NULL,
  events = NULL,
  survey = TRUE,
  dag = TRUE,
  date_begin = NULL,
  date_end = NULL,
  na = list(),
  validation = list(),
  cast = list(),
  assignment = list(label = stripHTMLandUnicode, units = unitsFieldAnnotation),
  filter_empty_rows = TRUE,
  ...,
  config = list(),
  api_param = list(),
  csv_delimiter = ",",
  batch_size = NULL,
  error_handling = getOption("redcap_error_handling")
)

\method{exportRecordsTyped}{redcapOfflineConnection}(
  rcon,
  fields = NULL,
  drop_fields = NULL,
  forms = NULL,
  records = NULL,
  events = NULL,
  na = list(),
  validation = list(),
  cast = list(),
  assignment = list(label = stripHTMLandUnicode, units = unitsFieldAnnotation),
  ...
)

\method{exportReportsTyped}{redcapApiConnection}(
  rcon,
  report_id,
  drop_fields = NULL,
  na = list(),
  validation = list(),
  cast = list(),
  assignment = list(label = stripHTMLandUnicode, units = unitsFieldAnnotation),
  ...,
  config = list(),
  api_param = list(),
  csv_delimiter = ","
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{report_id}{\code{integerish(1)}. The ID number of the report to be exported.}

\item{fields}{\code{character} or \code{NULL}. Vector of fields to be returned.  If \code{NULL},
all fields are returned (unless \code{forms} is specified).}

\item{drop_fields}{\code{character} or \code{NULL}. A vector of field names to remove from
the export.}

\item{forms}{\code{character} or \code{NULL}. Vector of forms to be returned.  If \code{NULL},
all forms are returned (unless \code{fields} is specified.}

\item{records}{\code{character} or \code{integerish}. A vector of study ID's
to be returned.  If \code{NULL}, all subjects are returned.}

\item{events}{A \code{character} vector of events to be returned from a
longitudinal database.  If \code{NULL}, all events are returned. When
using a \code{redcapOfflineConnection} object, this argument is unvalidated,
and only rows that match one of the values given are returned;
misspellings may result in unexpected results.}

\item{survey}{\code{logical(1)}. When \code{TRUE}, the survey identifier field
(e.g., \code{redcap_survey_identifier}) and survey timestamp fields
(e.g., \verb{[form_name]_timestamp}) will be exported
(relevant only when surveys are utilized in the project).}

\item{dag}{\code{logical(1)}. When \code{TRUE} the
\code{redcap_data_access_group} field will be included in the export \
when data access groups are utilized in the project.
This flag is only viable if the user whose token is
being used to make the API request is not in a data access group.
If the user is in a group, then this flag will revert to its default value.}

\item{date_begin}{\code{POSIXct(1)} or \code{NULL}. Ignored if \code{NULL} (default).
Otherwise, records created or modified after this date will be returned.}

\item{date_end}{\code{POSIXct(1)} or \code{NULL}. Ignored if \code{NULL} (default).
Otherwise, records created or modified before this date will be returned.}

\item{na}{A named \code{list} of user specified functions to determine if the
data is NA. This is useful when data is loaded that has coding for NA, e.g.
-5 is NA. Keys must correspond to a truncated REDCap field type, i.e.
{date_, datetime_, datetime_seconds_, time_mm_ss, time_hh_mm_ss, time, float,
number, calc, int, integer, select, radio, dropdown, yesno, truefalse,
checkbox, form_complete, sql}. The function will be provided the variables
(x, field_name, coding). The function must return a vector of logicals
matching the input. It defaults to \code{\link[=isNAorBlank]{isNAorBlank()}} for all
entries.}

\item{validation}{A named \code{list} of user specified validation functions. The
same named keys are supported as the na argument. The function will be
provided the variables (x, field_name, coding). The function must return a
vector of logical matching the input length. Helper functions to construct
these are \code{\link[=valRx]{valRx()}} and \code{\link[=valChoice]{valChoice()}}. Only fields that
are not identified as NA will be passed to validation functions.}

\item{cast}{A named \code{list} of user specified class casting functions. The
same named keys are supported as the na argument. The function will be
provided the variables (x, field_name, coding). The function must return a
vector of logical matching the input length. See \code{\link[=fieldValidationAndCasting]{fieldValidationAndCasting()}}}

\item{assignment}{A named \code{list} of functions. These functions are provided, field_name,
label, description and field_type and return a list of attributes to assign
to the column. Defaults to creating a label attribute from the stripped
HTML and UNICODE raw label and scanning for units={"UNITS"} in description}

\item{filter_empty_rows}{\code{logical(1)}. Filter out empty rows post retrieval.
Defaults to \code{TRUE}.}

\item{csv_delimiter}{\code{character}. One of \code{c(",", "\\t", ";", "|", "^")}. Designates the
delimiter for the CSV file received from the API.}

\item{batch_size}{\code{integerish(1)} or \code{NULL}. When \code{NULL},
all records are pulled. Otherwise, the records all pulled in batches of this size.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportRecordsTyped} returns a data frame with the formatted data.

\code{exportReportsTyped} returns a data frame with the formatted data.
}
\description{
These methods enable the user to export records from a
database or from a report. These methods have more control for casting
fields to R objects than \code{exportRecords}.
}
\details{
The 'offline' method operates on the raw (unlabeled) data
file downloaded from REDCap along with the data dictionary.
This is made available for instances where the API cannot be accessed for
some reason (such as waiting for API approval from the REDCap administrator).
\subsection{Record Identifier Fields}{

In all calls, the project's ID fields will be included--there is no option
provided to prevent this. Additionally, if the project has a secondary
unique field specified, it will also be included. Inclusion of these fields
is necessary to support some post-processing functions.

By default, the system fields \code{redcap_event_name},
\code{redcap_repeat_instrument}, and \code{redcap_repeat_instance} are
exported (when they are appropriate to the project). These are automatically
included by the API. However, if the user omits any of these in \code{fields}
or designates one in \code{drop_fields}, the final result will honor those
conditions. Excluding any of these identifiers may cause problems with
some post-processing functions that operate on repeating instrument data.

The combination of the project ID field, secondary unique field, and the
system fields are what uniquely identify an experimental unit. In nearly
all cases, it is desirable to have them all included.
}

\subsection{Record Batching}{

A 'batched' export is one where the export is performed over a series of
API calls rather than one large call.  For large projects on small servers,
this may prevent a single user from tying up the server and forcing others
to wait on a larger job.  The batched export is performed by first
calling the API to export the subject identifier field (the first field
in the meta data).  The unique ID's are then assigned a batch number with
no more than \code{batch_size} ID's in any single batch.  The batches are
exported from the API and stacked together.

In longitudinal projects, \code{batch_size} may not necessarily be the
number of records exported in each batch.  If \code{batch_size} is ten and
there are four records per patient, each batch will consist of 40 records.
Thus, if the user is concerned about tying up the server with a large,
longitudinal project, it would be prudent to use a smaller batch size.
}

\subsection{Inversion of Control}{

The final product of calling this is a \code{data.frame} with columns
that have been type cast to most commonly used analysis class (e.g. factor).
This version allows the user to override any step of this process by
specifying a different function for each of the stages of the type casting.
The algorithm is as follows:
\enumerate{
\item Detect NAs in returned data (\code{na} argument).
\item Run \code{validate} functions for the field_types.
\item On the fields that are not NA and pass validate do the specified cast.
}

It is expected that the \code{na} and \code{validate} overrides should
rarely be used. Their exposure via the function parameters is to future
proof against possible bugs in the defaults, and allows for things that
higher versions of REDCap add as possible field types. I.e., the overrides
are for use to continue using the library when errors or changes to REDCap
occur.

The cast override is one where users can specify things that were controlled
by an ever increasing set of flags before. E.g., \code{dates=as.Date} was
an addition to allow dates in the previous version to be overridden if the
user wanted to use the Date class. In this version, it would appear called
as \verb{cast=list(_date=as.Date))}. See \code{\link[=fieldValidationAndCasting]{fieldValidationAndCasting()}}
for a full listing of package provided cast functions.
}
}
\section{Functions}{
\itemize{
\item \code{exportRecordsTyped()}: Export records with type casting.

\item \code{exportReportsTyped()}: Export reports with type casting.

\item \code{exportRecordsTyped(redcapOfflineConnection)}: Export records without API access.

}}
\section{Zero-Coded Check Fields}{

A zero-coded check field is a field of the REDCap type \code{checkbox} that has
a coding definition of \verb{0, [label]}. When exported, the field names for
these fields is \verb{[field_name]___0}. As in other checkbox fields, the
raw data output returns binary values where 0 represent and unchecked
box and 1 represents a checked box. For zero-coded checkboxes, then, a
value of 1 indicates that 0 was selected.

This coding rarely presents a problem when casting from raw values
(as is done in \code{exportRecordsTyped}). However, casting from coded or
labeled values can be problematic, as it In this case, it becomes
indeterminate from context if the intent of \code{0} is 'false' or the coded
value '0' ('true') ...

The situations in which casting may fail to produce the desired results are\tabular{lll}{
   Code \tab Label \tab Result \cr
   0 \tab anything other than "0" \tab Likely to fail when casting from coded values \cr
   0 \tab 0 \tab Likely to fail when casting from coded or labeled values \cr
}


Because of the potential for miscast data, casting functions will issue
a warning anytime a zero-coded check field is encountered. A separate
warning is issued when a field is cast from coded or labeled values.

When casting from coded or labeled values, it is strongly recommended that
the function \code{\link[=castCheckForImport]{castCheckForImport()}} be used. This function permits the
user to state explicitly which values should be recognized as checked,
avoiding the ambiguity resulting from the coding.
}

\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export records with default settings
exportRecordsTyped(rcon)

# Export records with no factors
exportRecordsTyped(rcon, 
                   cast = default_cast_character)
                   
# Export records for specific records
exportRecordsTyped(rcon, 
                   records = 1:3)
                   
# Export records for specific instruments
exportRecordsTyped(rcon, 
                   forms = c("registration", "visit_1", "medications"))
                   
# Export records using filterLogic, an API parameter not provided
# in the exportRecordsTyped function signature
exportRecordsTyped(
  rcon, 
  records = 1:3, 
  api_param = list(filterLogic = "[age_at_enrollment] > 25")
)
                   
                   
                   
# Export a report 
exportReports(rcon, 
              report_id = 12345)
              
              
# Export records using files downloaded from the user interface
rcon_off <- 
  offlineConnection(
    meta_data = 
      system.file(file.path("extdata/offlineConnectionFiles", 
                            "TestRedcapAPI_DataDictionary.csv"), 
                  package = "redcapAPI"), 
    records = 
      system.file(file.path("extdata/offlineConnectionFiles",
                            "TestRedcapAPI_Records.csv"), 
                  package = "redcapAPI"))

exportRecordsTyped(rcon_off)
}

}
\seealso{
\subsection{Other records exporting functions}{

\code{\link[=exportRecords]{exportRecords()}}, \cr
\code{\link[=exportReports]{exportReports()}}, \cr
\code{\link[=exportBulkRecords]{exportBulkRecords()}}
}

\subsection{Field validations and casting}{

\code{\link[=fieldValidationAndCasting]{fieldValidationAndCasting()}}, \cr
\code{\link[=reviewInvalidRecords]{reviewInvalidRecords()}}
}

\subsection{Post-processing functionality}{

\code{\link[=recastRecords]{recastRecords()}}, \cr
\code{\link[=guessCast]{guessCast()}}, \cr
\code{\link[=guessDate]{guessDate()}}, \cr
\code{\link[=castForImport]{castForImport()}}, \cr
\code{\link[=mChoiceCast]{mChoiceCast()}}, \cr
\code{\link[=splitForms]{splitForms()}}, \cr
\code{\link[=widerRepeated]{widerRepeated()}}
}
}
