% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportProjectXml.R
\name{exportProjectXml}
\alias{exportProjectXml}
\alias{exportProjectXml.redcapApiConnection}
\title{Export Entire Project as REDCap XML File}
\usage{
exportProjectXml(
  rcon,
  file,
  return_metadata_only = TRUE,
  records = NULL,
  fields = NULL,
  events = NULL,
  survey = FALSE,
  dag = FALSE,
  export_files = FALSE,
  ...
)

\method{exportProjectXml}{redcapApiConnection}(
  rcon,
  file,
  return_metadata_only = TRUE,
  records = NULL,
  fields = NULL,
  events = NULL,
  survey = FALSE,
  dag = FALSE,
  export_files = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{file}{\code{character(1)} The file to which the XML export will be
saved.}

\item{return_metadata_only}{\code{logical(1)}. When \code{TRUE} (default)
only meta data values are returned. When \code{FALSE}, project records
data are also exported.}

\item{records}{\code{character} or \code{integerish}. A vector of study id's
to be returned.  When \code{NULL}, all subjects are returned.}

\item{fields}{\code{character}. Vector of fields to be returned.  When \code{NULL},
all fields are returned (unless \code{forms} is specified).}

\item{events}{A \code{character}. Vector of events to be returned from a
longitudinal database.  When \code{NULL}, all events are returned.}

\item{survey}{\code{logical(1)}. When \code{TRUE} the survey identifier fields
(e.g., \code{redcap_survey_identifier}) or survey timestamp fields
(e.g., \verb{[form_name]_timestamp}) will be included in the export
when surveys are utilized in the project.}

\item{dag}{\code{logical(1)}. When \code{TRUE} the \code{redcap_data_access_group}
field is exported when data access groups are utilized in the project.}

\item{export_files}{\code{logical(1)}. When \code{TRUE} will cause the XML returned
to include all files uploaded for File Upload and Signature fields
for all records in the project. Setting this option to \code{TRUE} can
make the export very large and may prevent it from completing if the
project contains many files or very large files.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
These methods enable the user to export a project's settings
as an XML file in CDISC ODM format. This file may be used to transfer
the project to another project, REDCap instance, or any other
CDISC ODM compliant database.
}
\details{
The entire project (all records, events, arms, instruments,
fields, and project attributes) can be downloaded as a single XML
file, which is in CDISC ODM format (ODM version 1.3.1). This XML
file can be used to create a clone of the project (including its data,
optionally) on this REDCap server or on another REDCap server
(it can be uploaded on the Create New Project page). Because it is in
CDISC ODM format, it can also be used to import the project into
another ODM-compatible system.

When the \code{return_metadata_only} parameter is set to \code{FALSE}, the
Data Export user rights will be applied to any data returned. For example,
if the user has 'De-Identified' or 'Remove All Identifier Fields'
data export rights, then some data fields might be removed and
filtered out of the data set. To make sure that no data is
unnecessarily filtered out of the API request, the user should have
'Full Data Set' export rights in the project.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "token_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
xml_file <- tempfile(file.ext = ".xml")
exportProjectXml(rcon, 
                 file = xml_file)
}

  
  
}
\seealso{
\code{\link[=createRedcapProject]{createRedcapProject()}}
}
