% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumpart.R
\name{redist.run.enumpart}
\alias{redist.run.enumpart}
\title{Runs the enumpart algorithm}
\usage{
redist.run.enumpart(
  ordered_path,
  out_path,
  ndist = 2,
  all = TRUE,
  n = NULL,
  options = NULL
)
}
\arguments{
\item{ordered_path}{Path used in redist.prep.enumpart}

\item{out_path}{Valid path to output the enumerated districts}

\item{ndist}{number of districts to enumerate}

\item{all}{boolean. TRUE outputs all districts. FALSE samples n districts.}

\item{n}{integer. Number of districts to output if all is FALSE. Returns 
districts selected from uniform random distribution.}

\item{options}{Additional enumpart arguments. Not recommended for use.}
}
\value{
0 on success
}
\description{
Runs the enumpart algorithm
}
\examples{
\dontrun{
redist.run.enumpart(ordered_path = '../ordered', out_path = '../enumerated')
}
}
\references{
Benjamin Fifield, Kosuke Imai, Jun Kawahara, and Christopher T Kenny.
"The Essential Role of Empirical Validation in Legislative Redistricting Simulation." 
Forthcoming, Statistics and Public Policy.
}
