% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridUncertainty_functions.R
\name{gridUncertaintyRandom}
\alias{gridUncertaintyRandom}
\title{Function to compute AOO with grid uncertainty randomly with stop rule}
\usage{
gridUncertaintyRandom(ecosystem.data, grid.size, n.AOO.improvement,
  min.percent.rule = T, percent = 1, max.n.rounds = 1000)
}
\arguments{
\item{ecosystem.data}{Raster object of an ecosystem or species distribution.
Please use a CRS with units measured in metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}

\item{n.AOO.improvement}{Specifies the minimum number of rounds the
calculated AOO is not improved before stopping the function.}

\item{min.percent.rule}{Logical. If \code{TRUE}, a minimum area threshold
must be passed before a grid is counted as an AOO grid.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}.}

\item{max.n.rounds}{Specifies the maximum number of rounds to calculate AOOs.
Generally unused except to limit computation time.}
}
\value{
List containing the following:
\itemize{
 \item Data frame of summary statistics for the results
 \item Data frame showing the distance shifted in x and y directions used to
 create the AOO grid(s) and their associated AOOs
 \item List of RasterLayer(s) containing the AOO grid(s) which return the
 smallest AOO
}
}
\description{
\code{gridUncertaintyRandom} helps determine the minimum number of area of
occupancy (AOO) grid cells occupied by a species or ecosystem. It varies the
location of the AOO grid by shifting in randomly in both x- and y-
axes, returning summary statistics for the range of AOOs calculated, and the
RasterLayer(s) containing the grids with the minimum AOO. It automatically
stops when the AOO no longer improves after a specified number of rounds.
}
\examples{
crs.UTM55S <- '+proj=utm +zone=55 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs'
r1 <- raster(ifelse((volcano<130), NA, 1), crs = crs.UTM55S)
extent(r1) <- extent(0, 6100, 0, 8700)
x <- gridUncertaintyRandom(r1, grid.size = 10000, n.AOO.improvement = 50,
                           min.percent.rule = TRUE, percent = 1)
}
\references{
Bland, L.M., Keith, D.A., Miller, R.M., Murray, N.J. and
  Rodriguez, J.P. (eds.) 2016. Guidelines for the application of IUCN Red
  List of Ecosystems Categories and Criteria, Version 1.0. Gland,
  Switzerland: IUCN. ix + 94pp. Available at the following web site:
  \url{iucnrle.org/}
}
\seealso{
\code{\link{createGrid}} \code{\link{getAOOSilent}}

Other gridUncertainty functions: \code{\link{gridUncertaintyBase}},
  \code{\link{gridUncertaintyRandomManual}},
  \code{\link{gridUncertaintySimulation}},
  \code{\link{gridUncertainty}}
}
\author{
Calvin Lee \email{calvinkflee@gmail.com}. Nicholas Murray
  \email{murr.nick@gmail.com}
}
