% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algoInvHist.R
\name{findRI}
\alias{findRI}
\title{Function to estimate reference intervals for a single population}
\usage{
findRI(Data = NULL, NBootstrap = 0, seed = 123)
}
\arguments{
\item{Data}{(numeric) values specifying data points comprising pathological
and non-pathological values}

\item{NBootstrap}{(integer) specifying the number of bootstrap repetitions}

\item{seed}{(integer) specifying the seed used for bootstrapping}
}
\value{
(object) of class "RWDRI" with parameters optimized
}
\description{
The function estimates the optimal parameters lambda, mu and sigma for a raw data set contatining pathological 
and non-pathological values. The optimization is carried out via a multi-level grid search to 
minimize the cost function (negative log-likelihood with regularization) and to find a model that fits the 
distribution of the physiological values and thus separates pathological from non-pathological values.
}
\examples{

# first example

\donttest{
data(testcase1)
resRI <- findRI(Data = testcase1)
print(resRI)
plot(resRI, showPathol = FALSE)
}

# second example
data(testcase2)
resRI <- findRI(Data = testcase2)
print(resRI)

\donttest{
# third example, with bootstrapping 
data(testcase3)
resRI <- findRI(Data = testcase3, NBootstrap = 30, seed = 123)
print(resRI)
getRI(resRI, RIperc = c(0.025, 0.5, 0.975), CIprop = 0.95, pointEst ="fullDataEst")
getRI(resRI, RIperc = c(0.025, 0.5, 0.975), CIprop = 0.95, pointEst ="medianBS")
plot(resRI)
# plot without showing values and pathological distribution
plot(resRI, showValue = FALSE, showPathol = FALSE)
plot(resRI,  RIperc = c(0.025, 0.5, 0.975), showPathol = FALSE, showCI = TRUE) 

# forth example, with bootstrapping
data(testcase4)
resRI <- findRI(Data = testcase4, NBootstrap = 30)
plot(resRI,  RIperc = c(0.025, 0.5, 0.975), showPathol = FALSE, showCI = TRUE)
}
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
