% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_XPlength.R
\name{refseq_XPlength}
\alias{refseq_XPlength}
\title{Get the protein length from an XP accession}
\usage{
refseq_XPlength(xp)
}
\arguments{
\item{xp}{A character string of the XP id.}
}
\value{
A numeric value representing the aa length of the protein especified as \code{xp}.
}
\description{
\code{refseq_XPlength()} Returns the amino acid length from a single XP accession.
}
\examples{
 # Get the XM ids from a set of XP accessions
 xp = c("XP_004487758", "XP_004488550")
 sapply(xp, function(x) refseq_XPlength(x), USE.NAMES = FALSE)

}
\seealso{
\code{\link{refseq_XPfromXM}} to obtain the XP ids encoded by a set of XM ids.
}
\author{
Jose V. Die
}
