% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{build_model_q}
\alias{build_model_q}
\title{Incremental block modelling.}
\usage{
build_model_q(dv, blocks = NULL, data = NULL, opts = NULL, model = "lm")
}
\arguments{
\item{dv}{String of the variable name to be used as the dependent variable.}

\item{blocks}{List of variable names (or interaction terms) to add for each
block. Each list element should be a single string with terms for that
block. Variables from previous blocks will be included with each subsequent
block.}

\item{data}{An optional data frame containing the variables in the model. If
not found in \code{data}, the variables are taken from the environment from
which the function is called.}

\item{opts}{List of arguments to be passed to the model function.}

\item{model}{The type of model to use; only supports 'lm' at this time.}
}
\value{
A named list with the following elements:
\tabular{ll}{
  \code{formulas} \tab A list of the regression formulas used for each block.
  \cr
  \code{models} \tab A list of all regression models.\cr
}
}
\description{
\code{build_model_q} allows you to incrementally add terms to a linear
regression model.
}
\details{
Given a list of names of variables at each step, this function will run a
series of models, adding the terms for each block incrementally. Note that in
most cases it is easier to use \code{\link{build_model}} and pass variable names
in directly instead of strings of variable names. \code{build_model_q} uses
standard evaluation in cases where such evaluation is easier.

Note: Cases with missing data are dropped based on the final model that
includes all the relevant terms. This ensures that all the models are tested
on the same number of cases.
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model_q('Sepal.Length', list('Petal.Length + Petal.Width'),
    data=iris, model='lm')
summary(model1)
coef(model1)

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model_q('Sepal.Length', list('Species', 'Species + Petal.Length * Petal.Width'),
    data=iris, model='lm')
summary(model2)
coef(model2)
}
\seealso{
\code{\link{build_model}}
}

