% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_means.R
\name{cell_means}
\alias{cell_means}
\title{Estimated means.}
\usage{
cell_means(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm' or 'aov'.}

\item{...}{Additional arguments to be passed to the particular method for the
given model.}
}
\value{
The form of the value returned by \code{cell_means} depends on the
  class of its argument. See the documentation of the particular methods for
  details of what is produced by that method.
}
\description{
\code{cell_means} is a generic function for calculating the estimated means
of a linear model.
}
\examples{
# iris data
model <- lm(Sepal.Length ~ Petal.Length + Petal.Width, iris)
summary(model)
cell_means(model, Petal.Length)
}
\seealso{
\code{\link{cell_means.lm}}, \code{\link{cell_means.aov}}
}

