% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_slopes.R
\name{simple_slopes.merMod}
\alias{simple_slopes.merMod}
\title{Simple slopes of interaction.}
\usage{
\method{simple_slopes}{merMod}(model, levels = NULL, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'merMod' with at least one
interaction term.}

\item{levels}{A list with element names corresponding to some or all of the
variables in the model. Each list element should be a vector with the names
of factor levels (for categorical variables) or numeric values (for
continuous variables) at which to test that variable. \strong{Note:} If you
do not include 'sstest' as one of these levels, the function will not test
the simple effects for that variable.}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
A data frame with a row for each simple effect. The first few columns
  identify the level at which each variable in your model was set for that
  test. A 'sstest' value in a particular column indicates that this was the
  variable being tested. After columns for each variable, the data frame has
  columns for the slope of the test variable, the standard error, and t-value
  for the model.
}
\description{
\code{simple_slopes.merMod} calculates all the simple effects of an
interaction in a regression model.
}
\details{
If the model includes interactions at different levels (e.g., three two-way
interactions and one three-way interaction), the function will test the
simple effects of the highest-order interaction. If there are multiple
interactions in the highest order, it will test the first one in the model.
If you wish to test simple effects for a different interaction, simply switch
the order in the formula.

By default, this function will provide slopes at -1SD, the mean, and +1SD for
continuous variables, and at each level of categorical variables. This can be
overridden with the \code{levels} parameter.

If a categorical variable with more than two levels is being tested, you may
see multiple rows for that test. One row will be shown for each contrast for
that variable; the order is in the same order shown in \code{contrasts()}.
}
\examples{
# iris data
if (require(lme4, quietly=TRUE)) {
    model <- lmer(Sepal.Width ~ Sepal.Length * Petal.Length + (1|Species), data=iris)
    summary(model)
    simple_slopes(model)
    simple_slopes(model,
        levels=list(Sepal.Length=c(4, 5, 6, 'sstest'),
        Petal.Length=c(2, 3, 'sstest')))  # test at specific levels
}
}
\seealso{
\code{\link{simple_slopes.lm}}, \code{\link{simple_slopes.glm}},
  \code{\link{simple_slopes.lme}}
}

