% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{summary.block_aov}
\alias{summary.block_aov}
\title{Summarizing block ANOVA.}
\usage{
\method{summary}{block_aov}(object, ...)
}
\arguments{
\item{object}{An object of class "\code{block_aov}", usually, a result of a
call to \code{\link{build_model}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function computes and returns a named list of summary statistics
  of the fitted aov models given in \code{model}. The list has the following
  elements:
\tabular{ll}{
  \code{formulas} \tab A list of the aov formulas used for each block.
  \cr
  \code{residuals} \tab A matrix with quantiles of the residuals for each
  model.\cr
  \code{summaries} \tab A list with an ANOVA table for each model, including
  the sums of squares, mean squares, F values, and p-values.\cr
}
}
\description{
\code{summary} method for class "\code{block_aov}".
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
coef(model1)

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
coef(model2)
}
\seealso{
\code{\link{build_model}}, \code{\link{print.block_aov_summary}}
}

