% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinforced_VS.R
\name{modelPredict_VS}
\alias{modelPredict_VS}
\title{Risk prediction on the test set, variable selection version}
\usage{
modelPredict_VS(list_fpcaFit, list_cvfit, Xtest, Ztest, startT, tau)
}
\arguments{
\item{list_fpcaFit}{Obtained FPCA decomposition from \code{modelFit_VS}.}

\item{list_cvfit}{Obtained elastic net logistic regression from \code{modelFit_VS}.}

\item{Xtest}{Longitudinal biomarker data for subjects in the test set, matrix of \eqn{testn} by \eqn{nTotal}. Missing values
are denoted by NA.}

\item{Ztest}{Other baseline covariates for subjects in the test set.}

\item{startT}{Time of the first prediction, denoted by \eqn{t_1} in the manuscript. For instance, if the time grids are \eqn{{0,1/60,2/60,...,1}},
then startT = 25 means that the first prediction is made at \eqn{t = 24/60}.}

\item{tau}{The threshold value \eqn{\tau}.}
}
\value{
\item{final.label}{Predicted outcome \eqn{Y} for subjects in the test set, vector of length \eqn{testn}.}
\item{avg.cost}{Average cost when we applied this prediction procedure to the test set. }
\item{cost}{Cost for each subject, vector of length \eqn{testn}. For some subjects, we make a definite decision early. For others, we follow up with a long period of time. Hence the cost is different for each individual. }
}
\description{
For a fixed threshold value \eqn{\tau}, \code{modelPredict_VS} predicts the outcome \eqn{Y}  for subjects in the test set.
This function also outputs the cost associated with the prediction procedure. This function is used when the baseline
covariates Z are high-dimensional.
}
\examples{
# see the example from function reinforced_VS.
}
