'\"
'\" Generated from file 'img-ps.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
'\"
'\" -*- tcl -*- doctools
'\" -*- tcl -*- doctools = format-header.inc
.so man.macros
.TH "img-ps" n 1.3  "Img"
.BS
.SH "NAME"
img-ps \- Img, Adobe PostScript Format (ps)
.SH "SYNOPSIS"
package require \fBTk \fR
.sp
package require \fBimg::ps  ?1.3?\fR
.sp
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The package \fBimg::ps\fR is a sub-package of
\fBImg\fR. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::ps\fR.
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR so
that it supports files containing raster images in the
Adobe PostScript Format (ps). More specifically
\fBimg::ps\fR extends \fBTk\fR's \fBphoto\fR
image type.
.PP
The name of the new format handler is \fBps\fR.
This handler provides new additional configuration options. See
section \fBPostScript OPTIONS\fR for more detailed explanations.
.PP
Note that this package provides a \fBpdf\fR handler too, i.e. a
handler for the Adobe Portable Document Format. That handler accepts
the same options as the \fBps\fR handler.
.PP
The package delegates the actual conversion of data in PostScript and
PDF format into a raster image to the \fBghostscript\fR
application. It therefore depends upon the presence of said
application and is non-functional is \fBghostscript\fR is not
present.
.PP
All of the above means that in a call like
.TP
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.IP [1]
Image data in ps and PDF format (options \fB-data\fR
and \fB-file\fR) is detected automatically.
.IP [2]
The format names \fBps\fR and \fBpdf\fR are
recognized by the option \fB-format\fR.
In addition the value for the option is treated as list and may
contain any of the special options listed in section
\fBPostScript OPTIONS\fR.
.SH "PostScript OPTIONS"
The handler provides two options, both influencing the reading of
PostScript or PDF images. The handler is \fInot\fR able to write
images in PostScript or PDF.
.TP
\fB-index\fR \fIn\fR
This option is for reading from PostScript/PDF data containing more
than one page. When specified it will read the \fIn\fR'th page in the
data. The first page is at index \fB0\fR and will be read by
default, i.e. when the option is not specified.
.sp
\fINote:\fR This option is not yet implemented.
.TP
\fB-zoom\fR \fIX\fR \fIY\fR
Multiply image size by the given scale factors. If \fIY\fR is missing,
the default is the same as \fIX\fR. \fIX\fR and \fIY\fR are allowed to
be in floating point format, but they are rounded to the nearest
practically possible value. For postscript this means the zoom factors
should be multiples of 1/72.
.SH "REQUIREMENTS"
The code provided by Img does not perform the interpretation and
rasterizing of the input by itself but delegates this to the
\fBgs\fR application. This is the GhostScript implementation
of PostScript (and PDF).
.PP
If \fBgs\fR is not installed this format handler cannot be used.
.SH "SEE ALSO"
img-bmp, img-gif, img-ico, img-intro, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH "KEYWORDS"
ghostscript, gs, image handling, pdf, postscript, ps, tk
.SH "COPYRIGHT"
.nf
Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
.fi
