% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{nXplain}
\alias{nXplain}
\alias{nXplain,EotStack-method}
\title{Number of EOTs needed for variance explanation}
\usage{
\S4method{nXplain}{EotStack}(x, var = 0.9)
}
\arguments{
\item{x}{an \emph{EotStack}}

\item{var}{the minimum amount of variance to be explained by the modes}
}
\value{
an integer denoting the number of EOTs needed to explain \code{var}
}
\description{
The function identifies the number of modes needed to explain a certain amount of
variance within the response field.
}
\note{
This is a post-hoc function. It needs an \emph{EotStack}
created as returned by \code{\link{eot}}. Depending on the potency
of the identified EOTs, it may be necessary to compute a high number of
modes in order to be able to explain a large enough part of the variance.
}
\examples{
data(vdendool)

nh_modes <- eot(x = vdendool, y = NULL, n = 5,
                reduce.both = FALSE, standardised = FALSE,
                verbose = TRUE)

### How many modes are needed to explain 40\% of variance?
nXplain(nh_modes, 0.4)
}

