% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_t_test.R
\name{nice_t_test}
\alias{nice_t_test}
\title{Easy t-tests}
\usage{
nice_t_test(
  data,
  response,
  group = NULL,
  correction = "none",
  warning = TRUE,
  ...
)
}
\arguments{
\item{data}{The data frame.}

\item{response}{The dependent variable.}

\item{group}{The group for the comparison.}

\item{correction}{What correction for multiple comparison
to apply, if any. Default is "none" and the only other option
(for now) is "bonferroni".}

\item{warning}{Whether to display the Welch test warning or not.}

\item{...}{Further arguments to be passed to the \code{t.test}
function (e.g., to use Student instead of Welch test, to
change from two-tail to one-tail, or to do a paired-sample
t-test instead of independent samples).}
}
\value{
A formatted dataframe of the specified model, with DV, degrees of
freedom, t-value, p-value, the effect size, Cohen's d, and its
95\% confidence interval lower and upper bounds.
}
\description{
Easily compute t-test analyses, with effect sizes,
and format in publication-ready format. The 95\% confidence interval
is for the effect size, Cohen's d, both provided by the \code{effectsize} package.

This function relies on the base R \code{t.test} function, which
uses the Welch t-test per default (see why here:
\url{https://daniellakens.blogspot.com/2015/01/always-use-welchs-t-test-instead-of.html}).
To use the Student t-test, simply add the following
argument: \code{var.equal = TRUE}.
}
\examples{
# Make the basic table
nice_t_test(
  data = mtcars,
  response = "mpg",
  group = "am"
)

# Multiple dependent variables at once
nice_t_test(
  data = mtcars,
  response = names(mtcars)[1:7],
  group = "am"
)

# Can be passed some of the regular arguments
# of base [t.test()]

# Student t-test (instead of Welch)
nice_t_test(
  data = mtcars,
  response = "mpg",
  group = "am",
  var.equal = TRUE
)

# One-sided instead of two-sided
nice_t_test(
  data = mtcars,
  response = "mpg",
  group = "am",
  alternative = "less"
)

# One-sample t-test
nice_t_test(
  data = mtcars,
  response = "mpg",
  mu = 10
)

# Paired t-test instead of independent samples
nice_t_test(
  data = ToothGrowth,
  response = "len",
  group = "supp",
  paired = TRUE
)
# Make sure cases appear in the same order for
# both levels of the grouping factor
}
\seealso{
Tutorial: \url{https://rempsyc.remi-theriault.com/articles/t-test}
}
\keyword{differences}
\keyword{group}
\keyword{t-test}
