% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkout.R
\name{checkout}
\alias{checkout}
\title{Checkout a Repository}
\usage{
checkout(
  repos = getOption("repos"),
  ...,
  packages = NULL,
  clean = FALSE,
  project = NULL
)
}
\arguments{
\item{repos}{The \R package repositories to check out.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{packages}{The packages to be installed. When \code{NULL} (the default),
all packages currently used in the project will be installed.}

\item{clean}{Boolean; remove packages not recorded in the lockfile from
the target library? Use \code{clean = TRUE} if you'd like the library state
to exactly reflect the lockfile contents after \code{restore()}.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\description{
\code{renv::checkout()} can be used to install and use the latest packages
available from the requested repositories. This can be useful for cleaning
up a library which has become a mish-mash of packages installed from a
variety of disparate sources.
}
