% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore.R
\name{restore}
\alias{restore}
\title{Restore a Project}
\usage{
restore(
  project = NULL,
  ...,
  library = NULL,
  lockfile = NULL,
  repos = NULL,
  clean = FALSE,
  confirm = interactive()
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Optional arguments; reserved for future expansion.}

\item{library}{The library paths to be used during restore. See \strong{Library}
for details.}

\item{lockfile}{The lockfile to be used for restoration of the associated
project. When \code{NULL}, the most recently generated lockfile for this project
is used.}

\item{repos}{The repositories to use during restore, for packages installed
from CRAN or another similar R package repository. When set, this will
override any repositories declared in the lockfile. See also the
\code{repos.override} option in \link{config} for an alternate way to provide a
repository override.}

\item{clean}{Boolean; remove packages not recorded in the lockfile from
the target library? Use \code{clean = TRUE} if you'd like the library state
to exactly reflect the lockfile contents after \code{restore()}.}

\item{confirm}{Boolean; prompt the user before taking any action?}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Restore a project's dependencies from a lockfile, as previously generated by
\code{\link[=snapshot]{snapshot()}}.
}
\section{Library}{


When \code{renv::restore()} is called, packages from the lockfile are compared
against packages currently installed in the library paths specified by
\code{library}. Any packages which have changed will then be installed into the
default library. If \code{clean = TRUE}, then packages that exist within the
default library, but aren't recorded in the lockfile, will be removed as
well.
}

\examples{
\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
\seealso{
Other reproducibility: \code{\link{lockfile}},
  \code{\link{snapshot}()}
}
\concept{reproducibility}
