% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\title{Clean a Project}
\usage{
clean(project = NULL, ..., confirm = interactive())
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{confirm}{Boolean; prompt the user before taking any action?}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Clean up a project and its associated \R libraries.
}
\details{
The following actions will be taken:
\itemize{
\item Stale lockfiles (\verb{00LOCK-}) will be removed.
\item Leftover temporary directories in the project library will be removed.
\item Non-system packages installed in the system library will be removed.
\item Unused packages within the project will be removed.
\item Packages within the cache that are no longer used will be removed.
}
}
\examples{
\dontrun{

# clean the current project
renv::clean()

}
}
