% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowscols.R
\name{replyr_moveValuesToRows}
\alias{replyr_moveValuesToRows}
\title{Collect values found in columnsToTakeFrom as tuples (experimental, only suitable for a moderate number of columns, not fully tested on multiple data suppliers).}
\usage{
replyr_moveValuesToRows(data, nameForNewKeyColumn, nameForNewValueColumn,
  columnsToTakeFrom, ..., na.rm = FALSE, nameForNewClassColumn = NULL,
  tempNameGenerator = makeTempNameGenerator("replyr_moveValuesToRows"))
}
\arguments{
\item{data}{data.frame to work with.}

\item{nameForNewKeyColumn}{character name of column to write new keys in.}

\item{nameForNewValueColumn}{character name of column to write new values in.}

\item{columnsToTakeFrom}{character array names of columns to take values from.}

\item{...}{force later columns to bind by name.}

\item{na.rm}{logical if TRUE remove rows with NA in nameForNewValueColumn.}

\item{nameForNewClassColumn}{optional name to land original cell classes to.}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}
}
\value{
data item
}
\description{
Collect values found in columnsToTakeFrom as tuples naming which column the value came from (placed in nameForNewKeyColumn)
and value found (placed in nameForNewValueColumn).  This is essentially a \code{tidyr::gather}, \code{dplyr::melt}, or anti-pivot.
Similar interface as in the \code{cdata} package (though does not perform pre/post condition checks).
}
\examples{

d <- data.frame(
  index = c(1, 2, 3),
  info = c('a', 'b', 'c'),
  meas1 = c('m1_1', 'm1_2', 'm1_3'),
  meas2 = c(2.1, 2.2, 2.3),
  stringsAsFactors = FALSE)
replyr_moveValuesToRows(d,
              nameForNewKeyColumn= 'meastype',
              nameForNewValueColumn= 'meas',
              columnsToTakeFrom= c('meas1','meas2'),
              nameForNewClassColumn= 'origMeasurementClass')
# cdata::moveValuesToRows(d,
#                         nameForNewKeyColumn= 'meastype',
#                         nameForNewValueColumn= 'meas',
#                         columnsToTakeFrom= c('meas1','meas2'),
#                         nameForNewClassColumn= 'origMeasurementClass')

}
