% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{buildJoinPlan}
\alias{buildJoinPlan}
\title{Build a join plan}
\usage{
buildJoinPlan(tDesc, ..., check = TRUE)
}
\arguments{
\item{tDesc}{description of tables from \code{\link{tableDescription}} (and likely altered by user). Note: no column names must intersect with names of the form \code{table_CLEANEDTABNAME_present}.}

\item{...}{force later arguments to bind by name.}

\item{check}{logical, if TRUE check the join plan for consistency.}
}
\value{
detailed column join plan (appropriate for editing)
}
\description{
Please see \code{vignette('DependencySorting', package = 'replyr')} and \code{vignette('joinController', package= 'replyr')} for more details.
}
\examples{

d <- data.frame(id=1:3, weight= c(200, 140, 98))
tDesc <- rbind(tableDescription('d1', d),
               tableDescription('d2', d))
tDesc$keys[[1]] <- list(PrimaryKey= 'id')
tDesc$keys[[2]] <- list(PrimaryKey= 'id')
buildJoinPlan(tDesc)

}
\seealso{
\code{\link{tableDescription}}, \code{\link{inspectDescrAndJoinPlan}}, \code{\link{makeJoinDiagramSpec}}, \code{\link{executeLeftJoinPlan}}
}
