% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_tag}
\alias{repo_tag}
\title{Add tags to an item.}
\usage{
repo_tag(rp, name = NULL, newtags, tags = NULL)
}
\arguments{
\item{rp}{An object of class repo.}

\item{name}{An item name.}

\item{newtags}{A list of tags that will be added to the item's tag
list.}

\item{tags}{A list of tags: newtags will be added to all items
matching the list.}
}
\value{
Used for side effects.
}
\description{
Add tags to an item.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", "tag1")
rp$print(show="t")
rp$tag("item1", "tag2")
rp$print(show="t")

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_untag, repo_set
}

